#include "mbed.h"

extern Serial pc;
extern int frequ; //unit kHz
extern char dev_addr; //fixed

char get_half_byte(int *); //defined in I2C_read.cpp 

void read_bit(int bit_pos) {
//    pc.printf("\n\r\tstart hot-read");
    int i;
    char temp = 0;
    int delay1 = 20;
    int delay2 = 2 * delay1;
    //DigitalIn sda(p9,PullNone);
    DigitalInOut sda(p9,PIN_OUTPUT,PullNone,1);
    DigitalOut scl(p10,1);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    scl = 1;
    sda = 1;
    
    //Transmit Stop (scl high followed by sda high)
    sda = 0;
    wait_us(delay2);
    scl = 1;
    wait_us(delay1);
    sda = 1;
    
    //Generater Start
    wait_us(4);
    sda = 0;
    wait_us(delay1);
    scl = 0;
    wait_us(delay2);
    //Txr Dev Addr 0x01 for read
    for(i = 7; i > 0; i = i-1) {
        wait_us(delay2);
        scl = 1;
        wait_us(delay2);
        scl = 0;
    }
    sda = 1;
    wait_us(delay2);
    scl = 1;
    wait_us(delay2);
    scl = 0; 
    wait_us(delay2);    
    //Recieve ACK
    sda.input(); 
    scl = 1;
    wait_us(delay2);
    if (sda !=0) {
        pc.printf("\n\n \r\tNo Ack reg pointer :(");
        wait_us(20);
    }
    scl = 0; 
    wait_us(10);                  
    //Start of Hot Read. Move the pointer to corresponding bit
    for(i = 7; i > bit_pos; i = i-1) {
        scl = 1;
        wait_us(delay2);
        scl = 0;
        wait_us(delay2);
    }
    pc.printf("\n\n\n\r\tWaiting at bit position %d ..... Monitor adc_op_clk pin\n\n\r\tPress 'q' to quit hot read : ", i);    
    while(temp!='q') {
        temp = pc.getc();
    }
    //send out the remaining clock pulses
    for(; i >= 0; i = i-1) {
        scl = 1;
        wait_us(delay2);
        scl = 0;
        wait_us(delay2);
    }    
    //Transmit NACK (pull sda high before the 9th pulse)
    sda.output();
    sda = 1;
    wait_us(delay2);
    scl = 1;
    wait_us(delay2);
    scl = 0;
    wait_us(delay2);
    sda = 1;
    wait_us(10);
    //Transmit Stop (scl high followed by sda high)
    sda = 0;
    wait_us(delay2);
    scl = 1;
    wait_us(delay1);
    sda = 1;
    wait_us(200);  
    sda.~DigitalInOut();
    scl.~DigitalOut();   
} 

void hot_read() {
    char reg_ptr = 0x55;
    char temp;
    int flag1 = 0;
    char bit_position = 0;
    I2C i2c(p9,p10);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    pc.printf("\n\n\n\r\tYahoooo! Lets Perform a Hot Read");       
Re_enter:
    flag1 = 0;
    //Read Pointer to the Register that needs to be read
    while (!flag1) {
        pc.printf("\n\n\r\tEnter Register Address in hex (0 to f): ");
        reg_ptr = get_half_byte(&flag1);
        if (flag1==0) pc.printf(" \n\r\t\033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    }
    //Read the bit at which hot read is to be performed
    flag1=0;
    while (!flag1) {
        pc.printf("\n\n\r\tEnter bit position to be read (0 to 7): ");
        bit_position = get_half_byte(&flag1);
        if (bit_position > 7) flag1 = 0;
        if (flag1==0) pc.printf(" \n\r\t\033[%dm Invalid Choice!! No worries, let us try again \033[%dm",41,40);
    }              

    pc.printf("\n\n\n\r\t\033[%dm", 44);//change backround to blue
    pc.printf(" Device Address (fixed) = 0x%2.2X ; Register Pointer = 0x%2.2X ; bit position = %d ",dev_addr, reg_ptr, bit_position);
    pc.printf("\033[%dm", 40);//change backround to black
    
    pc.printf("\n\n\n\r\tContinue Read? (y/n) [Press 'e' to re-enter]: ");  
    temp = 0;
    while ( temp!='y' && temp!='n' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'n') {
        pc.printf("\n\n\r\tAborting Register Read :(");
        return;
    }
    if (temp == 'e') {
        pc.printf(" \n\n\n\r\tOk, let us try again :)");
        goto Re_enter;
    }
    i2c.frequency(frequ*1000);
    i2c.stop(); //add a stop after a previous hot-read
    i2c.start();
    flag1 = i2c.write(dev_addr); 
    if (flag1 != 1) pc.printf("\n\n\n\r\tNo Ack for dev addr :(");
    flag1 = i2c.write(reg_ptr);
    if (flag1 != 1) pc.printf("\n\n\r\tNo Ack reg pointer :(");
    i2c.stop(); 
    pc.printf("\n\n\n\r\tPress 's' to start hot read [Press 'a' to abort] : ");    
    while(temp!='s' && temp!='a') {
        temp = pc.getc();
    } 
    if (temp == 'a') {
        pc.printf("\n\n\r\tAborting Register Read :(");
        return;
    }
    read_bit(bit_position);  
}