#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(USBTX,USBRX);//シリアル通信
SDFileSystem sd(p5,p6,p7,p8,"sd");//SDスロットピン
PwmOut servo(p24);//パラシュート分離用サーボ
//PwmOut servo(p21);//パラシュート分離用サーボブレボ
AnalogIn accel_x(p20);//加速度X軸
AnalogIn accel_y(p19);//加速度Y軸
AnalogIn accel_z(p18);//加速度Z軸
DigitalIn cds(p29);//光センサ
PwmOut moterL(p21);
PwmOut moterR(p22);
DigitalOut stby (p11);//モータドライバ
DigitalOut AIN(p12);//モータドライバ正転逆転
DigitalOut led1(LED1);
float x,y,z;

int main()
   
    {
     stby=1;
     AIN=1;
     float pwidth;
     servo.period_ms(20);//出力周期 20ms=(50Hz)
     
     while(1) {
    x = accel_x;//ｘｙｚの値をそれぞれ格納
    y = accel_y;
    z = accel_z;
          
         pc.printf("X:%1.3f Y:%1.3f Z:%1.3f \r\n", accel_x.read() ,accel_y.read() ,accel_z.read() );
         pwidth=0.001;
         servo.pulsewidth(pwidth);
         if(cds==1){
             led1=1;
             }
         if(x>=0.8 || y>=0.8 || z>=0.8){//＊＊＊＊＊＊＊＊＊＊＊＊＊調整必要
              pwidth=0.00075;
              servo.pulsewidth(pwidth);
              wait(10.0);
              moterL.pulsewidth(0.0020);                                  //パルス幅指定
              moterR.pulsewidth(0.0020);
             
              //return(0);
              } 
              //return(0);
 
         if(x<0.8 || y<0.8 || z<0.8){
             FILE *fp = fopen ("/sd/AccLog.txt","a"); //GPSデータをSDに書き込み
                if(fp == NULL) {
                    error("Could not open file for write\n");
                }
                fprintf(fp,"x:%.3f  ",x);
                fprintf(fp,"y:%.3f  ",y);
                fprintf(fp,"z:%.3f\r\n",z);
                fclose(fp);
                }
 
 
 
  } 
}