// ヘッダのインクルード
#include "mbed.h"
#include "BLEDevice.h"
#include "ble_gap.h"
#include "Gap.h"

#define CHARACTERISTIC_LEN 100

// デバイス名の登録
const static char  DEVICE_NAME[] = "mbed_HRM1017";

// UUIDの登録
static const uint8_t UUID_BRIL_SERVICE[]    = {0x4d,0x92,0x37,0xc0,0xbd,0x5b,0x45,0x93,0xad,0x55,0xd8,0xf5,0x95,0xcf,0xe2,0xea};
static const uint8_t UUID_CHAR_DATA[]       = {0xe5,0xc1,0xcf,0x6e,0xe0,0x57,0x40,0x08,0x98,0x21,0x17,0x71,0x10,0x24,0xe8,0x85};

// ble_gap_evt_scan_req_report_t report_rssi;
// 
uint8_t gRwData[CHARACTERISTIC_LEN] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
uint8_t g_txdata[100];
uint8_t g_rxdata[100];

BLEDevice   ble;
Serial      pc(USBTX, USBRX);

GattCharacteristic  gDataCharacteristic ( UUID_CHAR_DATA, gRwData, sizeof(gRwData), sizeof(gRwData),
                                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);

// 送信用バッファ
uint8_t     txTempPayload[100];

// タイマ送信用バッファ
uint8_t     txUpdate[5] = { 0, 0, 0, 0, 0 };

// 送信用GATTの宣言
GattCharacteristic txChar( 0x3A01, txTempPayload, 100, 100,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_INDICATE |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE );

// 受信用バッファ
uint8_t     rxTempPayload[100];

// 受信用GATTの宣言
GattCharacteristic rxChar( 0x3A02, rxTempPayload, 100, 100,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE );

// RSSI値用変数
int8_t     g_rssi;

// RSSI値用GATTの宣言
GattCharacteristic rssiChar( 0x3A03, (uint8_t *)g_rssi, 1, 1,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE );

GattCharacteristic *txChars[] = {&txChar, };
GattCharacteristic *rxChars[] = {&rxChar, };
GattCharacteristic *rssiChars[] = {&rssiChar, };
GattCharacteristic *RwDataChars[] = {&gDataCharacteristic};

GattService     txService( 0x181C, txChars, sizeof(txChars) / sizeof( GattCharacteristic * ) );
GattService     rxService( 0x181C, rxChars, sizeof(rxChars) / sizeof( GattCharacteristic * ) );
GattService     rssiService( 0x181C, rssiChars, sizeof(rssiChars) / sizeof( GattCharacteristic * ) );

GattService     gBrilService = GattService(UUID_BRIL_SERVICE, RwDataChars, sizeof(RwDataChars) / sizeof(GattCharacteristic *));

uint16_t        uuid16_list[] = { 0x181C, };

static Gap::ConnectionParams_t connectionParams;

void onDisconnectionCallback( Gap::Handle_t handle, Gap::DisconnectionReason_t reason ){

    ble.startAdvertising();
    pc.printf( "Disconnect!!\r\n" );

}

void onConnectionCallback( Gap::Handle_t handle, Gap::addr_type_t type, const Gap::address_t addr,
                            Gap::addr_type_t addr_type_townAddrType, const Gap::address_t ownAddr,
                            const Gap::ConnectionParams_t *params ){

    pc.printf( "Connect!!\r\n" );

}

void onDataWrittenCallback( const GattCharacteristicWriteCBParams *params ){
    int i;
    int8_t p_rssi=0;
    int error = 0;
    
    uint16_t bytesread = params->len;

    pc.printf( "Written: %d Bytes.\r\n", bytesread );
    for( i = 0; i < bytesread; i++ ){
        pc.printf( "%02x",params->data[i] );
        if( ( i + 1 ) < bytesread ){
            pc.printf( ", " );
        }
    }

//    ble.updateCharacteristicValue( txChar.getValueAttribute().getHandle(), params->data, bytesread );
    
    error = sd_ble_gap_rssi_get( rxChar.getValueAttribute().getHandle(), ( int8_t * )p_rssi );
    sd_ble_gap_rssi_stop( rxChar.getValueAttribute().getHandle() );
    sd_ble_gap_rssi_start( rxChar.getValueAttribute().getHandle(), 0x00, 0x00 );

    pc.printf( "   RSSI: %d, ", p_rssi );
    pc.printf( "ERROR: %d\r\n", error );

    ble.updateCharacteristicValue( rssiChar.getValueAttribute().getHandle(), (uint8_t *)p_rssi, sizeof( p_rssi ) );


}

void tickerCallback( void ){
    uint16_t byteswrite = 1;

    ble.updateCharacteristicValue( txChar.getValueAttribute().getHandle(), txUpdate, byteswrite );
    
    txUpdate[0]++;
}

int main( void )
{

// 初期設定
    ble.init();
// コールバック関数の設定
    ble.onDisconnection( onDisconnectionCallback );
    ble.onConnection( onConnectionCallback );
    ble.onDataWritten(onDataWrittenCallback);

    ble.getPreferredConnectionParams( &connectionParams );

    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)uuid16_list, sizeof(uuid16_list));
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160);    // 100ms; in multiples of 0.625ms
    ble.setAdvertisingTimeout(0);       // アドバタイジングモードのタイムアウト無効
    
    sd_ble_gap_rssi_start( rxChar.getValueAttribute().getHandle(), 0x00, 0x00 );

// アドバタイズモード開始
    ble.startAdvertising();

// サービスの追加
    ble.addService( txService );
    ble.addService( rxService );
    ble.addService( rssiService );
    
// タイマーの設定
    Ticker  ticker;
    ticker.attach( tickerCallback, 0.5 );

    while(1){

        ble.waitForEvent();

    }
}