// ヘッダのインクルード
#include "mbed.h"
#include "BLEDevice.h"

#define CHARACTERISTIC_LEN 100

// デバイス名の登録
const static char  DEVICE_NAME[] = "mbed_HRM1017";

// UUIDの登録
static const uint8_t UUID_BRIL_SERVICE[]    = {0x4d,0x92,0x37,0xc0,0xbd,0x5b,0x45,0x93,0xad,0x55,0xd8,0xf5,0x95,0xcf,0xe2,0xea};
static const uint8_t UUID_CHAR_DATA[]       = {0xe5,0xc1,0xcf,0x6e,0xe0,0x57,0x40,0x08,0x98,0x21,0x17,0x71,0x10,0x24,0xe8,0x85};

// 
uint8_t gRwData[CHARACTERISTIC_LEN] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
int g_conflg = 0;
int g_test = 0;
int g_receiveflg = 0;
uint8_t g_txdata[100];
uint8_t g_rxdata[100];

BLEDevice   ble;
Serial      pc(USBTX, USBRX);

uint8_t     thermTempPayload[5] = { 1, 2, 3, 4, 5 };

GattCharacteristic  gDataCharacteristic ( UUID_CHAR_DATA, gRwData, sizeof(gRwData), sizeof(gRwData),
                                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);

GattCharacteristic  tempChar( GattCharacteristic::UUID_TEMPERATURE_MEASUREMENT_CHAR,
                                thermTempPayload, 100, 100,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_INDICATE |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE );

// バッテリーレベル用変数
uint8_t            batt = 100;     // Battery level
uint8_t            read_batt = 0;  // Variable to hold battery level reads

// バッテリーレベル用GATT
GattCharacteristic battLevel ( GattCharacteristic::UUID_BATTERY_LEVEL_CHAR,
                                (uint8_t *)batt, 1, 1,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE );

// 
GattCharacteristic *htmChars[] = {&tempChar, };
GattCharacteristic *battChars[] = {&battLevel, };
GattCharacteristic *RwDataChars[] = {&gDataCharacteristic};

GattService     htmService( GattService::UUID_HEALTH_THERMOMETER_SERVICE, htmChars, 
                                sizeof(htmChars) / sizeof(GattCharacteristic * ) );
GattService     battService( GattService::UUID_BATTERY_SERVICE, battChars,
                                sizeof(battChars) / sizeof(GattCharacteristic * ) );
GattService     gBrilService = GattService(UUID_BRIL_SERVICE, RwDataChars, sizeof(RwDataChars) / sizeof(GattCharacteristic *));

uint16_t        uuid16_list[] = {GattService::UUID_HEALTH_THERMOMETER_SERVICE,
                                    GattService::UUID_BATTERY_SERVICE};

static Gap::ConnectionParams_t connectionParams;

void onDisconnectionCallback( Gap::Handle_t handle, Gap::DisconnectionReason_t reason ){

    g_conflg = 0;
    ble.startAdvertising();
    pc.printf( "Disconnect!!\r\n" );

}

void onConnectionCallback( Gap::Handle_t handle, Gap::addr_type_t type, const Gap::address_t addr,
                            Gap::addr_type_t addr_type_townAddrType, const Gap::address_t ownAddr,
                            const Gap::ConnectionParams_t *params ){

    g_conflg = 1;
    pc.printf( "Connect!!\r\n" );

}

void onDataWrittenCallback( const GattCharacteristicWriteCBParams *params ){
    int i;
    
    uint16_t bytesread = params->len;

    batt--;
    if( batt < 0 ){
        batt = 100;
    }

    pc.printf( "Written %d Bytes.\r\n", bytesread );
    for( i = 0; i < bytesread; i++ ){
        pc.printf( "%02x",params->data[i] );
        if( ( i + 1 ) < bytesread ){
            pc.printf( ", " );
        }
    }
    pc.printf( "\r\n" );

    if( ( params->data[0] == 0x24 ) && ( params->data[1] == 0x02 ) ){
        g_receiveflg = 1;
    }

    ble.updateCharacteristicValue( tempChar.getValueAttribute().getHandle(), thermTempPayload, sizeof( thermTempPayload ) );
//    ble.updateCharacteristicValue(battLevel.getHandle(), (uint8_t *)&batt, sizeof(batt));
}

void create_data(){
    
    int i;

}

int main( void )
{

// 初期設定
    ble.init();
// コールバック関数の設定
    ble.onDisconnection( onDisconnectionCallback );
    ble.onConnection( onConnectionCallback );
    ble.onDataWritten(onDataWrittenCallback);

    ble.getPreferredConnectionParams( &connectionParams );

    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)uuid16_list, sizeof(uuid16_list));
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.setAdvertisingTimeout(0);       // アドバタイジングモードのタイムアウト無効

// アドバタイズモード開始
    ble.startAdvertising();

// サービスの追加
    ble.addService(htmService);
    ble.addService(battService);
    ble.addService(gBrilService);

    while(1){

        ble.waitForEvent();
        if( g_receiveflg ){

        }

    }
}