#ifndef MPU9250_INCLUDED
#define MPU9250_INCLUDED

#include "mbed.h"

#define MPU9250_ADDRESS (0x68 << 1)
#define PWR_MGMT_1 0x6b
#define WHO_AM_I 0x75

class MPU9250{
    I2C i2c;
    const static int ACCEL_RANGE = 2;
    
public:
    MPU9250(PinName sda,PinName scl);
    
    /*データシートによると0x75が返ってくるはずが0x73が返ってくる。原因不明*/
    int whoAmI(char* address);
    
    /*ジャイロと加速度の補正前の生データ*/
    int getAccelAndGyroRawData(float* accelX,float* accelY,float* accelZ,float* gyroX,float* gyroY,float* gyroZ);
    
    /*ジャイロと加速度のbitデータ*/
    int getAccelAndGyroBitData(int16_t* ax,int16_t* ay,int16_t* az,int16_t* gx,int16_t* gy,int16_t* gz);
    
private:
    /*最初はsleep modeなので起動する*/
    int wakeUp();
    
    int write2Bytes(char address,char register,char data);
};

#endif