#include "mbed.h"

/*
確認済みの機能
    １）電池の電圧を読み取る（だいたいあっていることも確認済み）
    ２）超音波距離測定モジュールから値を読み取れることを確認
        ただし、アナログから読み取る方法のみしか試していない。また、本来は得た値から距離に計算しなおす必要があるが、今はしていない。
    ３）シリアル通信でpcにデータを送れること。（これができればおそらくトワイライト経由でも通信可能のはず）
    ４）プログラムが書き込み可能であること。
〇〇〇書き込みの方法はラインで通知します〇〇〇
書きこみに必要なプログラムはここ
http://www3.big.or.jp/~schaft/hardware/tips/LPC1114/page002.html
    ちなみにこのブログは(主にArduino向きに書いてあるが)結構勉強になることが書いてあるのでざっくり読んでおくとよい。
もっとも、このやり方はあまり正しい方法ではなく、Linuxでlpc21ispをつかうのが正統派。
https://developer.mbed.org/users/ytsuboi/notebook/getting-started-with-mbed-lpc1114-ja/
センサのデータシートはここ
http://akizukidenshi.com/download/ds/maxbotix/MB1013.pdf
※このセンサは、電源投入時に前との距離が19cm以上ないとキャリブレーションに失敗して正しい値を返さない。去年はこれを知らずにひどい目にあった。
*/


//クラスを継承
AnalogIn batt(dp9);
AnalogIn maxsonar(dp4);
Serial twelite(dp16,dp15,9600);
DigitalOut led(dp14);

//変数
float battvoltage;
float distance;

//メイン
int main(){
    twelite.printf("Reset\n");
    led = 0;
    while(1){
        battvoltage = batt*2.0*3.3; //バッテリーからの電圧は10kΩの抵抗二つで分圧され、本来の電圧の半分の値で取得している。
        distance = maxsonar;
        twelite.printf("Batt = %8.3f , Distance = %8.5f\n",battvoltage,distance);
        led = !led;
        wait(1.0);
    }
}