//@todo Initのコマンドモード化or別プログラム化
//@todo Initで設定した値の反映をスマートに（ServoMやControllerMでupdate毎にGlobalから設定値を取り込むのではなく，paramSet的な関数を作って更新時に呼び出し）
//てかそもそもInit情報Globalに入れる必要ないのでは？

//@todo Cadence, Airspeed内でNC，Encorderクラスから継承
//@todo Buttonクラスを作り，TrimとSelectorの親クラスにする

//@todo 使っているライブラリの関数の説明追加

//servo回りはシリアルに変更 
//selector周りはコメントアウトしてる

//タスクの数に上限があるっぽい(6個以下)
//

#include "mbed.h"
#include "rtos.h"
#include "Global.h"
#include "Init.h"
#include "ServoSend.h"
#include "ControllerManager.h"
#include "Trim.h"
#include "Airspeed.h"
#include "Atmpress.h"
#include "Display.h"
//#include "Selector.h"
#include "TweLite_Sensors.h"

RawSerial pc(USBTX, USBRX);

Atmpress atmpress(PB_7, PA_15);//sda, scl
Display display(PC_4, PA_10, NC);//tx, rx, sw
ControllerManager controllerManager(PC_0,PC_1,PA_4,PA_1);//ele, rud, eletrimup, eletrimdown
ServoSend servoSend(PC_10, PC_11);//tx, rx
//Selector selector(p25);
DigitalOut wdt(PA_14);
Airspeed airspeed(PA_13, NC, NC);//p19,p20をInterruptInに使ってはいけない
TweLite_Sensors tweLite_Sensors(PC_12,PD_2);
//FlashMemoryのpin指定は Global.cpp 内

void pc_rx(){
    while(pc.readable()==1){
        //コマンドモードのon,offはここに入れるといい
        char buf = (char)pc.getc();
        pc.putc(buf);
        Global::initqueue.put((char*)buf);
    }
}



void initializeTask(void const *pvParameters){
    while(1){
        Init::getSerial();
    }
}

void controlTask(void const *pvParameters){
    while(1){
        //この中でpc.printfはしないほうがいいみたい（9600bpsだと遅延が起こる）
        controllerManager.update();
        servoSend.send();
        //selector.update();
        wdt = !wdt;//ウォッチドッグタイマのkickに相当
        Thread::wait(50);
    }
}

void sensorTask500(void const *pvParameters){
    while(1){
        airspeed.update();
        atmpress.update();
        Thread::wait(500);
    }
}

void twesensorTask(void const *pvParameters){
    while(1){
        tweLite_Sensors.update();
        //こっちでそれぞれのbatteryをupdata
        //更新周期はTickerのインターバルで指定
    }
}


void displayTask(void const *pvParameters){
    while(1){
        display.update();
        Thread::wait(50);
    }   
}



int main(void){
    pc.printf("start\n");
    pc.attach(pc_rx,Serial::RxIrq);
    Global::initialize();
    Thread InitializeTask(initializeTask);
    Thread ControlTask(controlTask, NULL, osPriorityRealtime);
    Thread SensorTask500(sensorTask500);
    Thread TwesensorTask(twesensorTask);
    Thread DisplayTask(displayTask);
    pc.printf("Task end\n");
    
    Thread::wait(osWaitForever);
}