#include "mbed.h"
#include "Global.h"
#include "TweLite_Sensors.h"
#include <string>


std::string TweLite_Sensors::str;

TweLite_Sensors::TweLite_Sensors(PinName tx, PinName rx) : twelite(tx,rx){
    receivef=0;
    request=0;
    size=0;
    twelite.baud(9600);
    twelite.attach(this,&TweLite_Sensors::twelite_rx,Serial::RxIrq);
    flipper.attach(this,&TweLite_Sensors::flip, 0.25);
}

void TweLite_Sensors::scan(){
    while(size<9){wait_ms(1);}//ここを空にするとループを抜けなくなる
    if(str[0]==CADENCEHEADER){//ヘッダ
        for(int i=0;i<8;i++){
            data[i]=str[i+1];
        }
        for(int i=0;i<=size-9;i++) str[i]=str[i+9];
        size-=9;
        cadencevalue = *(float*) data;
        cadenceBattery = *(float*) (data+4);
        Global::setcadence(cadencevalue);
        Global::setcadencevolt(cadenceBattery);
    }else if(str[0]==ULTSONICHEADER){
        for(int i=0;i<8;i++){
            data[i]=str[i+1];
        }
        for(int i=0;i<=size-9;i++) str[i]=str[i+9];
        size-=9;
        ultsonicvalue = *(float*) data;
        ultsonicBattery = *(float*) (data+4);
        Global::setultsonic(ultsonicvalue);
        Global::setultsonicvolt(ultsonicBattery);
    }else{
        for(int i=0;i<=size-9;i++) str[i]=str[i+9];
        size-=9;
    }
    //pc.printf("%d",size);//45以上になるとRTX error code: 0x00000001, task ID: 0x20000540
}

void TweLite_Sensors::twelite_rx() {
    while(twelite.readable()==1){
        if(receivef==0) {
            char c=twelite.getc();
            if(c==CADENCEHEADER){
                receivef=1;
                str[size]=CADENCEHEADER;//pushできない size()は0のまま//両方できるっぽい
                size++;
            }else if(c==ULTSONICHEADER){
                receivef=1;
                str[size]=ULTSONICHEADER;
                size++;
            }else {}//先頭がheaderではないとき
        }else if(receivef==1) {
            str[size]=twelite.getc();
            size++;
        }
        if(size%9==0) receivef=0;
    }
}

void TweLite_Sensors::flip(){
    if(request==CADENCE){
        twelite.putc(CADENCE);
        request=ULTSONIC;
    }else if(request==ULTSONIC){
        twelite.putc(ULTSONIC);
        request=CADENCE;
    }
    //Global::led=!Global::led;
}

void TweLite_Sensors::update(){
    scan();
}