#include "mbed.h"
#include "Global.h"
#include "Atmpress.h"

Atmpress::Atmpress(PinName sda, PinName scl) : i2c(sda, scl){
    init();
}

void Atmpress::init(){
    char cmd[2];
    cmd[0]=LPS331_CTRL_REG1;//reg1
    cmd[1]=0xE0;//0b11100000.value
    i2c.write(LPS331_ADDRESS, cmd, 2); // init sensor
}

char Atmpress::readbyte(char cmd){
    char value[1];
    value[0] = cmd;
    //timeout.attach(this, &Atmpress::init, 1.0);
    i2c.write(LPS331_ADDRESS, value, 1);
    i2c.read(LPS331_ADDRESS|1, value, 1);
    //timeout.detach();
    return value[0];
}

int32_t Atmpress::addbyte(char xl, char l, char h){
    return (int32_t)h << 16 | (uint16_t)l << 8 | xl;
}

uint16_t Atmpress::addbyte(char l, char h){
    return (uint16_t)h << 8 | l;
}

double Atmpress::calcpressure(int32_t raw){
    return (float)raw / 4096;
}

double Atmpress::calctemperature(uint16_t raw){
    return (float)raw / 4096;
}

double Atmpress::getpressure(){
    return calcpressure(addbyte(readbyte(LPS331_PRESS_OUT_XL), 
                                readbyte(LPS331_PRESS_OUT_L), 
                                readbyte(LPS331_PRESS_OUT_H)));
}

double Atmpress::gettemperature(){
    return calctemperature(addbyte(readbyte(LPS331_TEMP_OUT_L),
                                   readbyte(LPS331_TEMP_OUT_H)));
}

void Atmpress::update(){
    Global::setatmpress(getpressure());
}

