#include "mbed.h"
#include "Global.h"
#include "Airspeed.h"
#include "RotaryEncoder.h"



Airspeed::Airspeed(PinName chanA, PinName chanB, PinName index) 
    : onepulserotaryencoder(chanA, chanB, index, 2, RotaryEncoder::X2_ENCODING){
}


double Airspeed::calc(double input){
    double a;
    double b; 
    if(input*0.001*1.6 < 2){
        a = 0.001*1.6*0.9824;
        b = 0;
    }else{
        a = 0.001*1.6*0.5815;
        b = 0.8;
    }
    return input*a + b;//機速計の特性に合わせて変更
}
void Airspeed::initialize(){
    pasttime = Global::timer.read();
    onepulserotaryencoder.reset();
}
void Airspeed::update(){
    Global::setairspeed(calc(rpm(read(),Global::timer.read())));
}

double Airspeed::read(){
    //rotaryencoderの回転数

    return onepulserotaryencoder.getfloatrevolutions();
}
//pasttimeの初期化コンストラクタでした方がいいかも
double Airspeed::rpm(double revolutions,double time){
    double rpm_ = revolutions/(time-pasttime)*60;
    onepulserotaryencoder.reset();
    pasttime = time;
    return rpm_;
}
double Airspeed::get(){
    return calc(rpm(read(),Global::timer.read()));
}