#include "mbed.h"
#include "Global.h"
#include "Init.h"
#include <string>
#include <iostream>

std::string Init::strbuf;

//2016年度で追加したコマンド方式のニュートラル調整システム
//RTOS前提のプログラムとなっているが、RTOSを廃止しても同じようなものは作れるはず
//mbedとPCをUSBで接続してシリアル通信でデータを送信することによって、mainのpc_rx()でそのデータがGlobal::initqueueに格納される。
//それはinitializeTask()で常時待機しているgetSerialで読み込まれる。
//また、設定されたパラメータはGlobal::filewrite()することにより、mbedのLocalFileSystemで不揮発メモリにINIT.csvというファイル名で書き込まれる。
//そのINIT.csvは、mbed起動時にGlobal::fileread()によって読み込まれ、パラメータが更新される。(これにより電源が落ちてもパラメータは保持される)

void Init::getSerial(){
    osEvent evt = Global::initqueue.get();
    if(evt.status == osEventMessage){
        char temp = evt.value.v;
        strbuf.push_back(temp);
        if(temp == '\n'){
            std::string::size_type spaceIndex = strbuf.find(" ");
                
            if (spaceIndex != std::string::npos) {//数値データがあるコマンド（" "がある場合）
                char *gomi;
                std::string command = strbuf.substr(0, spaceIndex);
                double num = strtod(strbuf.substr(spaceIndex+1, strbuf.size()-2).c_str(), &gomi);//strbuf.size()-1には'\n'が入っている
                printf("coms=%s, num=%f\n", command.c_str(), num);
                setting(command, num);
                    
            }else{//数値データがないコマンド（" "がない場合）
                std::string command = strbuf.substr(0,strbuf.size()-2);
                setting(command);       
            }
            strbuf.clear();
        }
        if(strbuf.size() > 30){
            strbuf.clear();
        }
    }
}


void Init::setting(std::string command, double num){
    if(command == "eleneu"){
        Global::setneutralpitch(num);
    }else if(command == "elemax"){
        Global::setmaxpitch(num);
    }else if(command == "elemin"){
        Global::setminpitch(num);
    }else if(command == "rudneu"){
        Global::setneutralyaw(num);
    }else if(command == "rudmax"){
        Global::setmaxyaw(num);
    }else if(command == "rudmin"){
        Global::setminyaw(num);
                        
    }else if(command == "eleneudeg"){
        Global::setneutralpitchdegree(num);
    }else if(command == "elemaxdeg"){
        Global::setmaxpitchdegree(num);
    }else if(command == "elemindeg"){
        Global::setminpitchdegree(num);
    }else if(command == "rudneudeg"){
        Global::setneutralyawdegree(num);
    }else if(command == "rudmaxdeg"){
        Global::setmaxyawdegree(num);
    }else if(command == "rudmindeg"){
        Global::setminyawdegree(num);
                    
    }else if(command == "elemaxplay"){
        Global::setmaxpitchplayratio(num);
    }else if(command == "eleminplay"){
        Global::setminpitchplayratio(num);                        
    }else if(command == "rudmaxplay"){
        Global::setmaxyawplayratio(num);
    }else if(command == "rudminplay"){
        Global::setminyawplayratio(num);
    }else if(command == "eletrim"){
        Global::settrimpitchrate(num);
                                
    }else{
        printf("Invalid Input\n");
    }
}

void Init::setting(std::string command){
    if(command == "eleneu"){
        Global::setneutralpitch(Global::getpitch()+Global::getneutralpitch());
    }else if(command == "elemax"){
        Global::setmaxpitch(Global::getpitch()+Global::getneutralpitch());
    }else if(command == "elemin"){
        Global::setminpitch(Global::getpitch()+Global::getneutralpitch());
    }else if(command == "rudneu"){
        Global::setneutralyaw(Global::getyaw()+Global::getneutralyaw());
    }else if(command == "rudmax"){
        Global::setmaxyaw(Global::getyaw()+Global::getneutralyaw());
    }else if(command == "rudmin"){
        Global::setminyaw(Global::getyaw()+Global::getneutralyaw());
                        
    }else if(command == "eleneudeg"){
        Global::setneutralpitchdegree(Global::getpitchdegree());
    }else if(command == "elemaxdeg"){
        Global::setmaxpitchdegree(Global::getpitchdegree());
    }else if(command == "elemindeg"){
        Global::setminpitchdegree(Global::getpitchdegree());
    }else if(command == "rudneudeg"){
        Global::setneutralyawdegree(Global::getyawdegree());
    }else if(command == "rudmaxdeg"){
        Global::setmaxyawdegree(Global::getyawdegree());
    }else if(command == "rudmindeg"){
        Global::setminyawdegree(Global::getyawdegree());
        
    }else if(command == "show"){
        showParam();
    }else if(command == "write"){
        //ここで，ニュートラル情報をLocalFileに保存
        Global::filewrite();
                                        
    }else{
        printf("Invalid Input\n");
    }
}

void Init::showParam(){
    printf("------Servo  Parameter------\n");
    printf("elevatorNeutral(eleneu)  = %f\n", Global::getneutralpitch());
    printf("elevatorMax(elemax)      = %f\n", Global::getmaxpitch());
    printf("elevatorMin(elemin)      = %f\n", Global::getminpitch());
    printf("rudderNeutral(rudneu)    = %f\n", Global::getneutralyaw());
    printf("rudderMax(rudmax)        = %f\n", Global::getmaxyaw());
    printf("rudderMin(rudmin)        = %f\n", Global::getminyaw());
    printf("----Controller Parameter----\n");
    printf("elevatorNeutral(eleneudeg)  = %f\n", Global::getneutralpitchdegree());
    printf("elevatorMax(elemaxdeg)      = %f\n", Global::getmaxpitchdegree());
    printf("elevatorMin(elemindeg)      = %f\n", Global::getminpitchdegree());
    printf("rudderNeutral(rudneudeg)    = %f\n", Global::getneutralyawdegree());
    printf("rudderMax(rudmaxdeg)        = %f\n", Global::getmaxyawdegree());
    printf("rudderMin(rudmindeg)        = %f\n", Global::getminyawdegree());
    printf("-------Play Parameter-------\n");
    printf("elevatorMaxPlay(elemaxplay)  = %f\n", Global::getmaxpitchplayratio());
    printf("elevatorMinPlay(eleminplay)  = %f\n", Global::getminpitchplayratio());
    printf("rudderMaxPlay(rudmaxplay)    = %f\n", Global::getmaxyawplayratio());
    printf("rudderMinPlay(rudminplay)    = %f\n", Global::getminyawplayratio());
    printf("-------Trim Parameter-------\n");
    printf("elevatorTrimRate(eletrim) = %f\n", Global::gettrimpitchrate());
    printf("----------------------------\n");
}