#include "mbed.h"
#include "Global.h"
#include "rtos.h"
#include "FlashManager.h"
extern RawSerial pc;

//クラスじゃなくてnamespaceのほうが綺麗にかけるかもね

Queue<char, 20> Global::initqueue;
//----------------FlashMemory(pin指定はここで)--------------------------------------------
SPI Global::spi(PA_7, PA_6, PA_5);// mosi, miso, sclk
FlashManager Global::memory(spi, PB_9);//spi, cs
//FlashManager Global::memory(PA_7, PA_6, PA_5, PB_9);
//----------------普段は変動しない変数------------------------------------------------------
//サーボのパラメータ（角度(度数法)で設定）max，minはニュートラルを基準にしている
double Global::maxpitch = 5.0;
double Global::minpitch = -5.0;
double Global::neutralpitch = 0;
double Global::maxyaw = 30.0;
double Global::minyaw = -30.0;
double Global::neutralyaw = 0;
//ジョイスティックのパラメータ(mbedのAnalogIn値[0,1])/max, min, neu全て[0,1]の絶対的な値をとる
double Global::maxpitchdegree = 1.0;
double Global::minpitchdegree = 0;
double Global::neutralpitchdegree = 0.5;
double Global::maxyawdegree = 1.0;
double Global::minyawdegree = 0;
double Global::neutralyawdegree = 0.5;
//ジョイスティックの遊び([-1,1]でニュートラルを0とした時の値)
double Global::maxpitchplayratio = 0.1;
double Global::minpitchplayratio = -0.1;
double Global::maxyawplayratio = 0.1;
double Global::minyawplayratio = -0.1;
//トリムの変化率（角度(度数法)で設定）
double Global::trimpitchrate = 0.5;

//----------------周期的に変動する変数------------------------------------------------------
double Global::pitch;
double Global::pitchdegree;//controllerの生データ
int    Global::inttrimpitch;
double Global::yaw;
double Global::yawdegree;//controllerの生データ
int    Global::inttrimyaw;
double Global::airspeed;
float Global::cadence;
float Global::ultsonic;
double Global::atmpress;
//int    Global::selector;
float Global::cadencevolt;
float Global::ultsonicvolt;
double Global::servovolt;
double Global::miconvolt;

int Global::pitchtime;
int Global::pitchdegreetime;
int Global::inttrimpitchtime;
int Global::yawtime;
int Global::yawdegreetime;
int Global::inttrimyawtime;
int Global::airspeedtime;
int Global::cadencetime;
int Global::ultsonictime;
int Global::atmpresstime;
//int Global::selectortime;
int Global::cadencevolttime;
int Global::ultsonicvolttime;
int Global::servovolttime;
int Global::miconvolttime;

//----------------どこからでも使えるled,スイッチ,タイマーの一括管理-----------------------------
Timer Global::timer;
//DigitalOut Global::led(LED2);

//ここでINIT.csvファイルが読み込まれる
void Global::initialize(){
    timer.start();
    memory.reset();
    fileread();
}

//INITファイルの読み込み
void Global::fileread(){
    /***********Memoryに値が保存されていない場合filewrite()**********/
    
    /************************************************************/
   
   vector<double> param = memory.readdouble(0x0,17);
   
   setneutralpitch(param[0]);
   setmaxpitch(param[1]);
   setminpitch(param[2]);
   setneutralyaw(param[3]);
   setmaxyaw(param[4]);
   setminyaw(param[5]);
   
   setneutralpitchdegree(param[6]);
   setmaxpitchdegree(param[7]);
   setminpitchdegree(param[8]);
   setneutralyawdegree(param[9]);
   setmaxyawdegree(param[10]);
   setminyawdegree(param[11]);
   
   setmaxpitchplayratio(param[12]);
   setminpitchplayratio(param[13]);
   setmaxyawplayratio(param[14]);
   setminyawplayratio(param[15]);
   settrimpitchrate(param[16]);
   
   pc.printf("read\n");
}

//INITファイルの書き込み
void Global::filewrite(){
    vector<double> param;
    
    param.push_back(getneutralpitch());
    param.push_back(getmaxpitch());
    param.push_back(getminpitch());
    param.push_back(getneutralyaw());
    param.push_back(getmaxyaw());
    param.push_back(getminyaw());
    
    param.push_back(getneutralpitchdegree());
    param.push_back(getmaxpitchdegree());
    param.push_back(getminpitchdegree());
    param.push_back(getneutralyawdegree());
    param.push_back(getmaxyawdegree());
    param.push_back(getminyawdegree());
    
    param.push_back(getmaxpitchplayratio());
    param.push_back(getminpitchplayratio());
    param.push_back(getmaxyawplayratio());
    param.push_back(getminyawplayratio());
    param.push_back(gettrimpitchrate());
    /*
    for(int i=0;i<17;i++){
        param.push_back(i*0.1);
    }*/
    memory.writedouble(0x0,param);
    pc.printf("written\n");
}

//init等で更新される変数
double Global::getmaxpitch(){return maxpitch;}
double Global::getminpitch(){return minpitch;}
double Global::getneutralpitch(){return neutralpitch;}
double Global::getmaxyaw(){return maxyaw;}
double Global::getminyaw(){return minyaw;}
double Global::getneutralyaw(){return neutralyaw;}

void Global::setmaxpitch(double _maxpitch){maxpitch = _maxpitch;}
void Global::setminpitch(double _minpitch){minpitch = _minpitch;}
void Global::setneutralpitch(double _neutralpitch){neutralpitch = _neutralpitch;}
void Global::setmaxyaw(double _maxyaw){maxyaw = _maxyaw;}
void Global::setminyaw(double _minyaw){minyaw = _minyaw;}
void Global::setneutralyaw(double _neutralyaw){neutralyaw = _neutralyaw;}

double Global::getmaxpitchdegree(){return maxpitchdegree;}
double Global::getneutralpitchdegree(){return neutralpitchdegree;}
double Global::getminpitchdegree(){return minpitchdegree;}
double Global::getmaxyawdegree(){return maxyawdegree;}
double Global::getneutralyawdegree(){return neutralyawdegree;}
double Global::getminyawdegree(){return minyawdegree;}

void Global::setmaxpitchdegree(double _maxpitchdegree){maxpitchdegree=_maxpitchdegree;}
void Global::setneutralpitchdegree(double _neutralpitchdegree){neutralpitchdegree=_neutralpitchdegree;}
void Global::setminpitchdegree(double _minpitchdegree){minpitchdegree=_minpitchdegree;}
void Global::setmaxyawdegree(double _maxyawdegree){maxyawdegree=_maxyawdegree;}
void Global::setneutralyawdegree(double _neutralyawdegree){neutralyawdegree=_neutralyawdegree;}
void Global::setminyawdegree(double _minyawdegree){minyawdegree=_minyawdegree;}


double Global::getmaxpitchplayratio(){return maxpitchplayratio;}
double Global::getminpitchplayratio(){return minpitchplayratio;}
double Global::getmaxyawplayratio(){return maxyawplayratio;}
double Global::getminyawplayratio(){return minyawplayratio;}

void Global::setmaxpitchplayratio(double _maxpitchplayratio){maxpitchplayratio=_maxpitchplayratio;}
void Global::setminpitchplayratio(double _minpitchplayratio){minpitchplayratio=_minpitchplayratio;}
void Global::setmaxyawplayratio(double _maxyawplayratio){maxyawplayratio=_maxyawplayratio;}
void Global::setminyawplayratio(double _minyawplayratio){minyawplayratio=_minyawplayratio;}

double Global::gettrimpitchrate(){return trimpitchrate;}

void Global::settrimpitchrate(double _trimpitchrate){trimpitchrate=_trimpitchrate;}

//常に更新される変数
double Global::getpitch(){return pitch;}
double Global::getpitchdegree(){return pitchdegree;}
int    Global::getinttrimpitch(){return inttrimpitch;}
double Global::getyaw(){return yaw;}
double Global::getyawdegree(){return yawdegree;}
int    Global::getinttrimyaw(){return inttrimyaw;}
double Global::getairspeed(){return airspeed;}
float Global::getcadence(){return cadence;}
float Global::getultsonic(){return ultsonic;}
double Global::getatmpress(){return atmpress;}
//int    Global::getselector(){return selector;}
float Global::getcadencevolt(){return cadencevolt;}
float Global::getultsonicvolt(){return ultsonicvolt;}
double Global::getservovolt(){return servovolt;}
double Global::getmiconvolt(){return miconvolt;}

int Global::getpitchtime(){return pitchtime;}
int Global::getpitchdegreetime(){return pitchdegreetime;}
int Global::getinttrimpitchtime(){return inttrimpitchtime;}
int Global::getyawtime(){return yawtime;}
int Global::getyawdegreetime(){return yawdegreetime;}
int Global::getinttrimyawtime(){return inttrimyawtime;}
int Global::getairspeedtime(){return airspeedtime;}
int Global::getcadencetime(){return cadencetime;}
int Global::getultsonictime(){return ultsonictime;}
int Global::getatmpresstime(){return atmpresstime;}
//int Global::getselectortime(){return selectortime;}
int Global::getcadencevolttime(){return cadencevolttime;}
int Global::getultsonicvolttime(){return ultsonicvolttime;}
int Global::getservovolttime(){return servovolttime;}
int Global::getmiconvolttime(){return miconvolttime;}

void Global::setpitch(double _pitch){
    pitch = _pitch;
    pitchtime = timer.read_ms();
}
void Global::setpitchdegree(double _pitchdegree){
    pitchdegree = _pitchdegree;
    pitchdegreetime = timer.read_ms();
}
void Global::setinttrimpitch(int _inttrimpitch){
    inttrimpitch = _inttrimpitch;
    inttrimpitchtime = timer.read_ms();
}
void Global::setyaw(double _yaw){
    yaw = _yaw;
    yawtime = timer.read_ms();
}
void Global::setyawdegree(double _yawdegree){
    yawdegree = _yawdegree;
    yawdegreetime = timer.read_ms();
}
void Global::setinttrimyaw(int _inttrimyaw){
    inttrimyaw = _inttrimyaw;
    inttrimyawtime = timer.read_ms();
}
void Global::setairspeed(double _airspeed){
    airspeed = _airspeed;
    airspeedtime = timer.read_ms();
}
void Global::setcadence(float _cadence){
    cadence = _cadence;
    cadencetime = timer.read_ms();
}
void Global::setultsonic(float _ultsonic){
    ultsonic = _ultsonic;
    ultsonictime = timer.read_ms();
}
void Global::setatmpress(double _atmpress){
    atmpress = _atmpress;
    atmpresstime = timer.read_ms();
}
/*void Global::setselector(int _selector){
    selector = _selector;
    selectortime = timer.read_ms();
}*/
void Global::setcadencevolt(float _cadencevolt){
    cadencevolt = _cadencevolt;
    cadencevolttime = timer.read_ms();
}
void Global::setultsonicvolt(float _ultsonicvolt){
    ultsonicvolt = _ultsonicvolt;
    ultsonicvolttime = timer.read_ms();
}
void Global::setservovolt(double _servovolt){
    servovolt = _servovolt;
    servovolttime = timer.read_ms();
}
void Global::setmiconvolt(double _miconvolt){
    miconvolt = _miconvolt;
    miconvolttime = timer.read_ms();
}
