#ifndef _FlashManager_H_
#define _FlashManager_H_

#include <vector>
#include "mbed.h"
#include "SPI_MX25R.h"

/* FlashMemoryであるSPI_MX25Rのラッパークラス
 * マイコンを起動したら最初にFlashMemoryをresetすること
 * readがうまくできなかったりしたら，resetすると直るかもしれない
 */
 
 
using namespace std;

class FlashManager
{
public:
    //FlashManager(SPI spi, PinName cs, Serial* _pc);//デバッグ用
    FlashManager(SPI spi, PinName cs);
    //FlashManager(PinName mosi, PinName miso, PinName sclk, PinName cs);
    //SPI _spi;
    //~FlashManager();

    //1Byte読み込み
    uint8_t read(int addr);
    uint32_t read4byte(int addr);
    //2Byte以上読み込み
    vector<uint8_t> read(int start_addr, int end_addr);
    vector<uint32_t> read4byte(int start_addr, int end_addr);
    vector<uint8_t> readSector(int sector);
    
    
    //任意の大きさのvector型データの書き込み
    void write(int addr, const vector<uint8_t>& data);
    void write(int addr, uint8_t data[], int size);
    void write4byte(int addr, const vector<uint32_t>& data);
    //セクター単位(4KB)でメモリー消去(sector = 0 ~ 63)
    void sectorErase(int sector);
    void chipErase();
    
    void reset();
    
    //--------------double用に追加した関数--------------//
    double readdouble(int addr);
    vector<double> readdouble(int start_addr, int size);
    void writedouble(int addr,double value);
    void writedouble(int addr, const vector<double>& data);

protected:
    SPI_MX25R m_mx25r;
    //Serial* pc;// デバッグ用
    bool isBusyInWriting();// return true when Program or Erase is in progress
    bool isValidRange(int addr);

};

#endif // _FlashManager_H_