#ifndef _INC_ControllerManager
#define _INC_ControllerManager
#include "mbed.h"
#include "Trim.h"

class ControllerManager {    
    
    AnalogIn controllerH;
    AnalogIn controllerV;
    Trim pitchtrim;
    
    double maxpitch;
    double minpitch;
    double maxyaw;
    double minyaw;
    
    double calc(double doublex,int intx);
    double pitchratioplayed(double pitchratio);
    double yawratioplayed(double yawratio);
    double doublepitch(double pitchratio);
    double doubleyaw(double yawratio);
    int intpitch(double pitchratio);
    int intyaw(double yawratio);
    
    public :
    ControllerManager(PinName h, PinName v, PinName hTrimup, PinName hTrimdown);
    void initialize();
    void update();
    
    double maxpitchdegree;
    double minpitchdegree;
    double neutralpitchdegree;
    double maxyawdegree;
    double neutralyawdegree;
    double minyawdegree;
    
    double maxpitchplayratio;
    double minpitchplayratio;
    double maxyawplayratio;
    double minyawplayratio;
    
    
    double pitchratio();
    double yawratio();

    double getpitch();
    double getyaw();
    double getpitch(double _pitchratio);
    double getyaw(double _yawratio);
    
    
};

#endif