#include "mbed.h"     // studio.hに相当
#include "INA226.hpp" //ina226内の内部処理

DigitalOut myled(LED1);//mbed内のLEDの点灯（動作確認用）無くてもいい
I2C i2c(p28,p27);      //I2Cで通信するためのポート設定
INA226 VCmonitor(i2c); //ina226の測定等の関数

int main() {           //マイコン起動時に始めにコールさせる
    unsigned short val; //通信確認時にエラーがないか確認するための変数
    double V,C;         //この変数に電圧電流が入ってる V：電圧 C：電流
    int count = 1;      // 測定毎にカウントされる変数
//ここから先無くてもいい
   printf("VCmonitor INA226 TEST Program. (BUILD:[" __DATE__ "/" __TIME__ "])\n");

    if(!VCmonitor.isExist()){//通信エラー確認
       printf("VCmonitor NOT FOUND\n");//エラーがあるとこのwhile内から抜けない
        while(1){}
    }
    
    printf("VCmonitor FOUND\n");

    val = 0;//初期値
    
    if(VCmonitor.rawRead(0x00,&val) != 0){//通信確認時にエラーがないか確認するための変数
        printf("VCmonitor READ ERROR\n");//エラーがあるとwhileから抜けない
        while(1){}
    }

    printf("VCmonitor Reg 0x00 : 0x%04x\n",val);
//ここより上はあっても無くてもいい
    VCmonitor.setCurrentCalibration();
    
    while(1) {                          //測定開始
        if((VCmonitor.getVoltage(&V) == 0) && (VCmonitor.getCurrent(&C) == 0)){
            printf("%d,V,%f,C,%f\n",count,V,C); //電圧、電流、カウント回数の表示
        }
        myled = 1; //LED点灯
        wait(0.5); //0.5秒待ち
        myled = 0; //LED消灯
        wait(0.5); //0.5秒待ち
        count++;   //一回カウント
    }
}