#include "mbed.h"
#include "TLC59116.h"

RawSerial pc(USBTX,USBRX,115200);
RawSerial dev(PA_9,PA_10,115200);
DigitalIn user(PC_13);
I2C i2c(PB_9,PB_8);

TLC59116 ledUnit[] = {TLC59116(&i2c,0x60 << 1),
                      TLC59116(&i2c,0x61 << 1),
                      TLC59116(&i2c,0x62 << 1),
                      TLC59116(&i2c,0x63 << 1)
                     };

void Init();

void I2cDeviceChecker();

void LightPanel(int i,uint32_t color);
void LightPanel(int i,uint8_t color_r,uint8_t color_g,uint8_t color_b);
void Gradation(int i,uint32_t start,uint32_t end,float per);
void Send();

uint32_t HSVtoRGB(float h,float s,float v);


int main()
{
    printf("Start Program\r\n");

    float count = 0;
    //int color = 0;

    Init();

    while(1) {
        count += 0.01;
        for (int i = 0; i < 16; i++) {
            LightPanel(i,HSVtoRGB(fmod((i / 16.0) + count,1),1,1));
        }

        Send();

        wait_us(1*1e6 / 60);
    }
}

void Init()
{
    for (int i = 0; i <= 16; i++) {
        LightPanel(i - 1,0x0);
        LightPanel(i,0xFFFFFF);
        Send();
        wait_us(100 * 1e3);
    }
}

void Gradation(int i,uint32_t start,uint32_t end,float per)
{
    uint8_t s_r = (start & 0xFF0000) >> 16;
    uint8_t s_g = (start & 0xFF00) >> 8;
    uint8_t s_b = (start & 0xFF);

    uint8_t e_r = (end & 0xFF0000) >> 16;
    uint8_t e_g = (end & 0xFF00) >> 8;
    uint8_t e_b = (end & 0xFF);

    uint8_t c_r = (e_r - s_r) * per + s_r;
    uint8_t c_g = (e_g - s_g) * per + s_g;
    uint8_t c_b = (e_b - s_b) * per + s_b;
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3,c_g);
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 1,c_r);
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 2,c_b);

}



void LightPanel(int i,uint32_t color)
{
    if (i >= 0 && i < 16) {
        uint8_t c_r = (color & 0xFF0000) >> 16;
        uint8_t c_g = (color & 0xFF00) >> 8;
        uint8_t c_b = (color & 0xFF);
        ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3,c_g);
        ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 1,c_r);
        ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 2,c_b);
    }
}

void LightPanel(int i,uint8_t c_r,uint8_t c_g,uint8_t c_b)
{
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3,c_g);
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 1,c_r);
    ledUnit[(int)(i / 4)].SetChannel((i % 4) * 3 + 2,c_b);
}

void Send()
{
    for (int i = 0; i < 4; i++) ledUnit[i].Send(2,12);
}

void I2cDeviceChecker()
{
    char data[1] = {0x00};
    for (int i = 0; i < 127; i++) {
        printf("%2x : %d\r\n",i,i2c.write(i<<1,data,1));
    }
}

uint32_t HSVtoRGB(float h,float s,float v)
{
    float r = v;
    float g = v;
    float b = v;
    if (s > 0.0f) {
        h *= 6.0f;
        int i = (int) h;
        float f = h - (float) i;
        switch (i) {
            default:
            case 0:
                g *= 1 - s * (1 - f);
                b *= 1 - s;
                break;
            case 1:
                r *= 1 - s * f;
                b *= 1 - s;
                break;
            case 2:
                r *= 1 - s;
                b *= 1 - s * (1 - f);
                break;
            case 3:
                r *= 1 - s;
                g *= 1 - s * f;
                break;
            case 4:
                r *= 1 - s * (1 - f);
                g *= 1 - s;
                break;
            case 5:
                g *= 1 - s;
                b *= 1 - s * f;
                break;
        }
    }
    r *= 255;
    g *= 255;
    b *= 255;
    return ((int)r << 16) | ((int)g << 8) | (int)b;

}