

#define mC 261.626
#define mD 293.665
#define mEb 311.13
#define mE 329.628
#define mF 349.228
#define mGb 369.99
#define mG 391.995
#define mAb 415.3
#define mA 440.000
#define mBb 466.16
#define mB 493.883
#define THRESH 80
#define COUNT_MAX 15
#define DIM 3
#define NUM_OF_NOTES 21
#define NUM_OF_SCALE 5

#include "C12832.h"
#include "mbed.h"
#include "rtos.h"
#include "MMA7660.h"
#include "USBHostMSD.h"
#include "wave_player.h"
#include <string>

using namespace std;

C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn fire(p14);
//DigitalIn up(p15);
//DigitalIn down(p12);
PwmOut sp1(p26);
InterruptIn myup(p15);
InterruptIn mydown(p12);
PwmOut led1(p23);
PwmOut led2(p24);
PwmOut led3(p25);
Semaphore three_slots(1);
Timer for_chat;


//for acceleration sonsor
MMA7660 acc(p28, p27);
float r[DIM];

//for music
AnalogOut DACout (p18);
wave_player waver(&DACout);
AnalogIn volumeMeter(p19);
AnalogIn musicSwitch(p20);
InterruptIn push(p14);
InterruptIn right(p16);
InterruptIn left(p13);
FILE *wave_file;
Mutex stdio_mutex;

int i=0;
int count = 0;
bool pushed = false;
int i_for20mm;
int i_for20mm_old = 0;
int scale = 0;
bool printflag = false;

float mm[]={mC,mD,mE,mF,mG,mA,mB,mC*2,mD*2,mE*2,mF*2,mG*2,mA*2,mB*2,mC*4};

float mmm[]={mC,mD,mE,mF,mG,mA,mB,mC*2,mD*2,mE*2,mF*2,mG*2,mA*2,mB*2,mC*4, mD*4,mE*4,mF*4,mG*4,mA*4,mB*4};//has 21
float notes[NUM_OF_SCALE][NUM_OF_NOTES] = {  {mC,mD,mE,mF,mG,mA,mB,mC*2,mD*2,mE*2,mF*2,mG*2,mA*2,mB*2,mC*4, mD*4,mE*4,mF*4,mG*4,mA*4,mB*4},             //major
                                             {mC,mD,mEb,mF,mG,mA,mBb,mC*2,mD*2,mEb*2,mF*2,mG*2,mA*2,mBb*2,mC*4, mD*4,mEb*4,mF*4,mG*4,mA*4,mBb*4},       //Dorian
                                             {mC,mD,mEb,mF,mG,mAb,mBb,mC*2,mD*2,mEb*2,mF*2,mG*2,mAb*2,mBb*2,mC*4, mD*4,mEb*4,mF*4,mG*4,mAb*4,mBb*4},    //natural minor　
                                             {mC,mEb,mF,mGb,mG,mBb,mC*2,mEb*2,mF*2,mGb*2,mG*2,mBb*2,mC*4,mEb*4,mF*4,mGb*4,mG*4,mBb*4,mC*8,mEb*8,mF*8},  //blues
                                             {mC,mE,mF,mG,mB,mC*2,mE*2,mF*2,mG*2,mB*2,mC*4,mE*4,mF*4,mG*4,mB*4,mC*8,mE*8,mF*8,mG*8,mB*8,mC*16}};        //Okinawa
                                             
string names[] = {"Major", "Dorian", "Minor", "Blues", "Okinawa"};

void printlcd(void)
{
        lcd.cls();
        stdio_mutex.lock();
        lcd.locate(10,10);
        lcd.printf("scale %s", names[scale]);
        printflag=false;
        stdio_mutex.unlock();
}
void intRise(void) 
{    
    if(for_chat.read_ms()>THRESH);
    {
        if(i<=13){
        i++;
        count ++;
        }
        sp1.period(1.0/mm[i]);
        sp1.write(0.5f);
        for_chat.reset();
    }
}
 
void intFall(void) 
{
    if(for_chat.read_ms()>THRESH);
    {
        if(i >=1){
        i--;
        count --;
        }
        sp1.period(1.0/mm[i]);
        sp1.write(0.5f);
        for_chat.reset();
    }        
}

void On(void)
{
    pushed = true;
}

void Off(void)
{
    pushed = false;
}

void scaleUp(void)
{
    if(for_chat.read_ms()>THRESH) ;
    {
        if (scale == NUM_OF_SCALE - 1)
        {
            scale = 0;
        } else
        {
            scale++;
        }
        printflag=true;
    }
    for_chat.reset();
}

void scaleDown(void)
{
    if(for_chat.read_ms()>THRESH) ;
    {
        if (scale == 0)
        {
            scale = NUM_OF_SCALE - 1;
        } else 
        {
            scale--;
        }
        printflag=true;
    }
    for_chat.reset();
}

void disp_thread(void const *argument) 
{
    float volume;
    float mswitch;
    
    while (true) 
    {
        volume = volumeMeter.read();
        mswitch = musicSwitch.read();
        i_for20mm = (int)(mswitch*20);//change 20 param
        
        if (i_for20mm != i_for20mm_old)
        {
            sp1.period(1.0/(notes[scale][i_for20mm]));
        }
        i_for20mm_old = i_for20mm;
        
        if(pushed)
        {
            sp1.write(volume);
        }
        else
        {
            sp1.write(0.0f);
        }   
        
        for_chat.reset();
        if(printflag)
        {
            printlcd();   
        }
        /////////////////////////////
        
        Thread::wait(50);
    }
} 
void wave_file_player(void const *argument)
 {
    waver.play(wave_file);
    fclose(wave_file);   
}    

int main() 
{
    wait(0.01);
    for_chat.start();
    myup.fall(&intRise);
    mydown.fall(&intFall);
    push.rise(&On);
    push.fall(&Off);
    right.rise(&scaleUp);
    left.rise(&scaleDown);
       
    Thread thread6(disp_thread);
    
    //for USB
    USBHostMSD msd("usb");
    while(!msd.connect())
    {
        Thread::wait(200);
    }
    
    //for music file
    stdio_mutex.lock();
    wave_file = fopen("/usb/music/BGMforMBED2.wav", "r");

    stdio_mutex.unlock();
    lcd.locate(10,10);
    lcd.printf("scale %s", names[0]);
    waver.play(wave_file);
    fclose(wave_file);   

    
    lcd.cls();
    wait(0.01);
    while(1)
    {
        
    }
}
 