

#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883
#define THRESH 80
#define COUNT_MAX 15
#include "C12832.h"
#include "mbed.h"
#include "rtos.h"

C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn fire(p14);
//DigitalIn up(p15);
//DigitalIn down(p12);
PwmOut sp1(p26);
InterruptIn myup(p15);
InterruptIn mydown(p12);
PwmOut led1(p23);
PwmOut led2(p24);
PwmOut led3(p25);
Semaphore three_slots(1);
Timer for_chat;

int i=0;
int count = 0;

float mm[]={mC,mD,mE,mF,mG,mA,mB,mC*2,mD*2,mE*2,mF*2,mG*2,mA*2,mB*2,mC*4};
void intRise(void) 
{    
    if(for_chat.read_ms()>THRESH);
    {
        if(i<=13){
        i++;
        count ++;
        }
        sp1.period(1.0/mm[i]);
        sp1.write(0.5f);
        for_chat.reset();
    }
}
 
void intFall(void) 
{
    if(for_chat.read_ms()>THRESH);
    {
        if(i >=1){
        i--;
        count --;
        }
        sp1.period(1.0/mm[i]);
        sp1.write(0.5f);
        for_chat.reset();
    }        
}


void r_thread(void const *argument) 
{
    float r = 0;
    while (true) 
    {
        r=0;
        while(r<=1)
        {
            three_slots.wait();
            switch(count){
                case 0:r = 0.0;break;
                case 1:r=0.07;break;
                case 2:r=0.13;break;
                case 3:r=0.20;break;
                case 4:r=0.27;break;
                case 5:r=0.34;break;
                case 6:r=0.41;break;
                case 7:r=0.48;break;
                case 8:r=0.55;break;
                case 9:r=0.62;break;
                case 10:r=0.69;break;
                case 11:r=0.76;break;
                case 12:r=0.83;break;
                case 13:r=0.90;break;
                case 14:r=0.97;break;
                }
            //r = (float)(count%COUNT_MAX)/COUNT_MAX;
            led1 = r;
            //r += 0.01;
            lcd.locate(0,16);
            lcd.printf("R: %3.2f",r);
            three_slots.release();
            Thread::wait(100);

        }
        while(r>0)
        {
            three_slots.wait();
            switch(count){
                case 0:r = 0.0;break;
                case 1:r=0.07;break;
                case 2:r=0.13;break;
                case 3:r=0.20;break;
                case 4:r=0.27;break;
                case 5:r=0.34;break;
                case 6:r=0.41;break;
                case 7:r=0.48;break;
                case 8:r=0.55;break;
                case 9:r=0.62;break;
                case 10:r=0.69;break;
                case 11:r=0.76;break;
                case 12:r=0.83;break;
                case 13:r=0.90;break;
                case 14:r=0.97;break;
                }
            //r = (float)(count%COUNT_MAX)/COUNT_MAX;
            led1 = r;
            //r -= 0.01;
            lcd.locate(0,16);
            lcd.printf("R: %3.2f",r);
            three_slots.release();
            Thread::wait(100);

        }
    }
} 
void g_thread(void const *argument) 
{
    float g = 0;
    while (true) 
    {
        g=0;
        while(g<=1)
        {
            three_slots.wait();
            switch(count){
                case 0:g = 0.50;break;
                case 1:g = 0.50;break;
                case 2:g=0.63;break;
                case 3:g=0.63;break;
                case 4:g=0.77;break;
                case 5:g=0.77;break;
                case 6:g=0.90;break;
                case 7:g=0.90;break;
                case 8:g=0.47;break;
                case 9:g=0.47;break;
                case 10:g=0.33;break;
                case 11:g=0.33;break;
                case 12:g=0.20;break;
                case 13:g=0.20;break;
                case 14:g=0.07;break;
                }
            led2 = g;
            //g += 0.01;
            lcd.locate(40,16);
            lcd.printf("G: %3.2f",g);
            three_slots.release();
            Thread::wait(200);
        }
        while(g>0)
        {
            three_slots.wait();
            switch(count){
                case 0:g = 0.50;break;
                case 1:g = 0.50;break;
                case 2:g=0.63;break;
                case 3:g=0.63;break;
                case 4:g=0.77;break;
                case 5:g=0.77;break;
                case 6:g=0.90;break;
                case 7:g=0.90;break;
                case 8:g=0.47;break;
                case 9:g=0.47;break;
                case 10:g=0.33;break;
                case 11:g=0.33;break;
                case 12:g=0.20;break;
                case 13:g=0.20;break;
                case 14:g=0.07;break;
                }
            led2 = g;
            //g -= 0.01;
            lcd.locate(40,16);
            lcd.printf("G: %3.2f",g);
            three_slots.release();
            Thread::wait(200);
        }
    }
} 
void b_thread(void const *argument) 
{
    float b = 0;
    while (true) 
    {
        b=0;
        while(b<=1)
        {
            three_slots.wait();
            switch(count){
                case 0:b = 1.00;break;
                case 1:b = 1.00;break;
                case 2:b=1.00;break;
                case 3:b=0.80;break;
                case 4:b=0.80;break;
                case 5:b=0.80;break;
                case 6:b=0.60;break;
                case 7:b=0.60;break;
                case 8:b=0.60;break;
                case 9:b=0.40;break;
                case 10:b=0.40;break;
                case 11:b=0.40;break;
                case 12:b=0.20;break;
                case 13:b=0.20;break;
                case 14:b=0.20;break;
                }
            led3 = b;
            //b += 0.01;
            lcd.locate(80,16);
            lcd.printf("B: %3.2f",b);
            three_slots.release();
            Thread::wait(300);
        }
        while(b>0)
        {
            three_slots.wait();
            switch(count){
                case 0:b = 1.00;break;
                case 1:b = 1.00;break;
                case 2:b=1.00;break;
                case 3:b=0.80;break;
                case 4:b=0.80;break;
                case 5:b=0.80;break;
                case 6:b=0.60;break;
                case 7:b=0.60;break;
                case 8:b=0.60;break;
                case 9:b=0.40;break;
                case 10:b=0.40;break;
                case 11:b=0.40;break;
                case 12:b=0.20;break;
                case 13:b=0.20;break;
                case 14:b=0.20;break;
                }
            led3 = b;
            //b -= 0.01;
            lcd.locate(80,16);
            lcd.printf("B: %3.2f",b);
            three_slots.release();
            Thread::wait(300);
        }
    }
} 
void count_thread(void const *argument) 
{
    while (true) 
    {
        three_slots.wait();
        lcd.locate(0,3);
        lcd.printf("Counting : %d   ",i);
        three_slots.release();
        Thread::wait(100);
    }
} 
int main() 
{
    wait(0.01);
    for_chat.start();
    myup.fall(&intRise);
    mydown.fall(&intFall);
    Thread thread1(r_thread,(void *)"Th 1");
    Thread thread2(g_thread,(void *)"Th 2");
    Thread thread3(b_thread,(void *)"Th 3");
    Thread thread4(count_thread,(void *)"Th 4");

    lcd.cls();
    wait(0.01);
    while(1)
    {
        //lcd.cls();

    }
}
 