//example_03_analogin_to_speaker
//センサから入力される値を使ってスピーカーを鳴らすサンプルコード
#include "mbed.h"

#define SP_OFF 0.0
#define SP_ON 0.5

//ピン設定
PwmOut speaker(A0);           //A0ピンを出力ピンに設定
AnalogIn analogInModule(A5);  //A5ピンをアナログ入力ピンに設定

//シリアル通信設定
Serial pc(USBTX, USBRX);

//変数
float analogInValue; //入力部品からの入力値を格納
float tunedValue;    //出力ように修正した入力値を格納
float interval;      //音出力の周期（ミリ秒）を格納

/*---------------------------------------------------------------------------*/
//tuning関数
//引数inputValueの値をもとに戻り値outputValueを計算する。
//サンプルではanalogInValueの値を出力に使えるよう変更するため使用
float tuning(float inputValue)
{
    float outputValue;
    //欲しい入力値の範囲になるよう入力値を調整
    //inputVlaueは0.0~1.0の範囲
    //このサンプルでは300Hz〜540Hzの周波数になるように変換している。
    outputValue = ((inputValue * 240.0f) + 300.0f);
    return outputValue;
}
/*---------------------------------------------------------------------------*/

int main()
{
    pc.printf("Hello World!\r\n");
    while(true) {
        //入力：センサーなどから入力値を読み取る
        analogInValue = analogInModule;
        pc.printf("analogInValue='%f' :", analogInValue);
        //analogValue小さい時はスピーカーをオフにする。
        if(analogInValue < 0.05f) {
            speaker.write(SP_OFF);
            pc.printf("OFF\n\r");
        } else {
            //処理：
            tunedValue = tuning(analogInValue); //tuning関数で入力値を調整
            interval = 1.0f / tunedValue;        //周波数(Hz)を周期(秒)に変換
            //出力設定
            speaker.period(interval);
            speaker.write(SP_ON);
            //確認用：PCへ現在の各変数の値を送信
            pc.printf("ON  tunedValue= '%f' interval= '%f' \r\n", tunedValue, interval);
        }
        wait(0.1);
    }
}
