//example_02ex_serial
//ボタンを押すとスピーカーを鳴らすサンプルコード
#include "mbed.h"

#define SP_OFF 0.0
#define SP_ON 0.5

#define mC 261.626 //「ド」の周波数(Hz)

PwmOut speaker(A0);//A0ピンを出力ピンに設定
DigitalIn button(D7);//D7ピンをデジタル入力ピンに設定

//シリアル通信設定
Serial pc(USBTX, USBRX);

int main()
{
    pc.printf("Hello World!\r\n"); //シリアル通信でマシンにHello World!(改行)を送る。
    button.mode(PullUp); 
    while(true) {
        //もしButtonが押されていたら(Btuttonからの入力が0Vであれば）
        if(button == 0) {
            //音を鳴らす
            speaker.period(1.0/mC);
            speaker.write(SP_ON);
            pc.printf("Button:ON\r\n");
        } else { 
            //そうでなければ音を止める
            speaker.write(SP_OFF);
            pc.printf("Button:OFF\r\n");
        }
        wait(0.1);
    }
}
