//example_02_button
//ボタンを押すとスピーカーを鳴らすサンプルコード
#include "mbed.h"

#define SP_OFF 0.0
#define SP_ON 0.5

#define mC 261.626 //「ド」の周波数(Hz)

PwmOut speaker(A0);//A0ピンを出力ピンに設定
DigitalIn button(D7);//D7ピンをデジタル入力ピンに設定

int main()
{
    button.mode(PullUp); 
    while(true) {
        //もしButtonが押されていたら(Btuttonからの入力が0Vであれば）
        if(button == 0) {
            //音を鳴らす
            speaker.period(1.0/mC);
            speaker.write(SP_ON);
        } else { 
            //そうでなければ音を止める
            speaker.write(SP_OFF);
        }
        wait(0.1);
    }
}
