///kigo-sat
///processingによるデータのVisual化
///Xbeeでのリアルタイム通信→XbeeWiFiを今後導入してもいいのでは
///Xbee3による最小パッケージの採用も今後やってみたい

#include "mbed.h"
#include "SCP1000.h"

Serial xbee(p9,p10,9600);

float map(float x, float in_min, float in_max, float out_min, float out_max);
DigitalOut  LED_1(LED1);
DigitalOut  LED_2(LED2);
DigitalOut  LED_3(LED3);
DigitalOut  LED_4(LED4);

FILE* fp;
LocalFileSystem local("local");

SCP1000 scp1000(p5,p6,p7,p8);

DigitalIn fall(p16);

AnalogIn ainZ(p17);
AnalogIn ainY(p18);
AnalogIn ainX(p19);
AnalogIn ain(p20);

char str[20];//unixtime用
int d;//unixtimeを数値に変換する用
int e=3200;//電圧センサのマッピング用
int f;//自由落下の判定用0=Falls,1=True
int offset_JAPAN = 32400; //JSTのためのオフセット
char c='a';
unsigned int pattern=0;

int SValue = 0;  //測定値
int SumV = 0;    //測定値累計
float mV = 0;    //センサー電圧
float Temp = 0;  //温度測定値

//int t=5;
//int s=6;
int j=0;
int main() {
    fall.mode( PullDown );
    while(1) {
        switch( pattern ){
            case 0:
                LED_1=LED_2=LED_3=LED_4=1;
                xbee.scanf("%s", str);
                if(c=='a'){
                    d=atoi(str);
                    set_time(d+offset_JAPAN);
                    pattern=1;
                }
                break;
            
            case 1:
                fp = fopen("/local/kigo.csv", "w");
                fprintf(fp,"time,temp,temp_2,press,x,y,z\r\n");
                pattern=2;
                break;
            
            case 2:
                LED_1=1;
                LED_2=LED_3=LED_4=0;
                if(fall==1)
                    f=1;
                else
                    f=0;
                time_t seconds = time(NULL);
                char day[16];
                strftime(day, 16, "%Y/%m/%d %a\n", localtime(&seconds));
                char time[16];
                strftime(time, 16, "%H:%M:%S\n", localtime(&seconds));
                SumV=0;
                for(int i=0;i<100;i++){
                    SumV=SumV+ain.read_u16();
                }
                SValue=SumV*0.01;
                mV=map(SValue,0,65535,0,e);
                Temp=map(mV,174,1205,-40,125);
                if(j>55){
                    fprintf(fp,"%d,%.1f,%.1f,%d,%1.3f,%1.3f,%1.3f,%d\r\n",seconds,Temp,scp1000.readTemperature(),scp1000.readPressure(),ainX.read(),ainY.read(),ainZ.read(),f);
                    j=0;
                    }
                    j++;
                xbee.scanf("%c",&c);
                switch(c){
                case 't':
                    xbee.printf("%.1f\n",Temp);
                    break;
                case 'p':
                    xbee.printf("%d\n",scp1000.readPressure()/100);
                    break;
                
                case 'x':
                    xbee.printf("%1.3f\n",ainX.read());
                    break;
                case 'y':
                    xbee.printf("%1.3f\n",ainY.read());
                    break;
                case 'z':
                    xbee.printf("%1.3f\n",ainZ.read());
                    break;
                case 'f':
                    xbee.printf("%d\n",f);
                    break;
                    
                case 'b':
                    pattern =3;
                    c='a';
                    str[0]='\0';
                    break;
                }
                break;
                
            case 3:
                LED_1=LED_2=1;
                LED_3=LED_4=0;
                fclose(fp);
                wait(5);
                pattern =0;
                break;   
            
            default:
                pattern=0;
                break;
        }
                
    }
}

float map(float x, float in_min, float in_max, float out_min, float out_max) {
return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}