#include "mbed.h"
#include "IRSensor.h"

//E. Hess
//Sensortest

DigitalOut led(LED1);           //Zustands-LED: Grüne LED für Benutzer

AnalogIn distance(PB_1);        //Input der Distanzsensoren
DigitalOut enableSensor(PC_1);  //Aktivierung der IRSensoren
DigitalOut bit0(PH_1);          //Ansteuerung der Sensoren 0-5 mit 3 Bits
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);
IRSensor sensors[6];            //Erstellt 6 IRSensor-Objekte als Array

DigitalOut leds[] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };    //LED-Outputs der Sensoren


//Titel printf()
void title() {
    printf("\f  <    \t\t   -   \t\t    >\n\r"); //"\f" Setzt den Cursor an den Anfang der nächsten Seite
}


int main() {
    float sensorMittelwert[6];   //Array der 6 Sensorenwerte
    float sensorTiefbass[6];
    int zaehler = 0;

    //Initialisiert Distanzsensoren und setzt sensorValue und sensorTiefbass auf NULL
    for( int i = 0; i < 6; i++) {
        sensors[i].init(&distance, &bit0, &bit1, &bit2, i);
        sensorMittelwert[i] = 0.0f;
        sensorTiefbass[i] = 0.0f;
    }
    enableSensor = 1;   //Aktiviert die IRSensoren

    while(1) {
        for(int j = 0; j < 25; j++){                 //Zählt 25 Sensorwerten pro Sensor zusammen
            for(int i = 0; i < 6; i++){
                sensorMittelwert[i] += sensors[i].read();
            }
            wait( 0.001f );
        }
        for(int i = 0; i < 6; i++){
            sensorTiefbass[i] = sensorTiefbass[i]*0.75f + sensorMittelwert[i]*0.25f;    //Verrechnet den neuen Wert mit dem alten
            sensorMittelwert[i] = 0.0f;                                                 //Setzt die Sensorwerte auf NULL
        }
        
        printf("%f\t%f\t%f\t\t%f\n\r", sensorTiefbass[3], sensorTiefbass[4], sensorTiefbass[2], sensorTiefbass[0]);   //Plottet die unteren Sensoren
        
        zaehler++;
        if(zaehler % 40 == 0) title();  //Erstellt nach 40 Zeilen eine neue Seite
    }
}
