#include "IRSensor.h"
#include <cmath>

//E. Hess
//IRSensor.cpp

//Konstruktor -> Erstellt ein IRSensor-Objekt
//AnalogIn* distance -> Liest die Voltanzahl des Sensors aus
//DigitalOut* bit0, bit1, bit2 -> Binär-Outputs wählen die 6 Sensoren an
//Int number -> Sensornummer als int (0-5)

IRSensor::IRSensor() {}

IRSensor::IRSensor(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{
    this->distance = distance;  //Weist den Objektvariablen, die eingegebenen Werte zu
    this->bit0 = bit0;
    this->bit1 = bit1;
    this->bit2 = bit2;
    this->number = number;
    this->filteredValue = 0.0f;
}

//Destruktor -> Löscht das IRSensor-Objekt
IRSensor::~IRSensor() {}

//Initialisiert nachträglich
void IRSensor::init(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number)
{
    this->distance = distance;  //Weist den Objektvariablen, die eingegebenen Werte zu
    this->bit0 = bit0;
    this->bit1 = bit1;
    this->bit2 = bit2;
    this->number = number;
    this->filteredValue = 0.0f;
}

//Distanzrechner
float IRSensor::read()
{
    *bit0 = (number >> 0) & 1;  //Vergleicht das Least-Significant-Bit von number mit 1 und setzt *bit0 (z.B. 5: 0000'0101 & 0000'0001 == 0000'0001)
    *bit1 = (number >> 1) & 1;  //Vergleicht das zweite Bit von rechts
    *bit2 = (number >> 2) & 1;  //Vergleicht das dritte Bit von rechts

    float d = distance->read();

    this->filteredValue = 0.99f* this->filteredValue + 0.01f * d;
    return d;
}

float IRSensor::readFitered()
{
    return this->filteredValue;
}

