#include "mbed.h"
#include "IRSensor.h"

//E. Hess
//Robotterbewegungen

DigitalOut led(LED1);

//Erstellt In- / Outputs
AnalogIn distance(PB_1); 
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);
IRSensor sensors[6];        //-> Was

//LED Indikatoren rund um Roboter
DigitalOut leds[] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };

//Timer-Objekt für LED- und Distanzsensor
Ticker t1;

//Motoren
DigitalOut enableMotorDriver(PB_2); //Erstellt das Objekt
PwmOut pwmL(PA_8);
PwmOut pwmR(PA_9);

//DistanzLEDs ->Was
void ledDistance(){
    for( int ii = 0; ii<6; ++ii)
        sensors[ii]< 0.1f ? leds[ii] = 1 : leds[ii] = 0;
}

//Blinkt beim Start und startet die DistanzLEDs
void ledShow(){
    static int timer = 0;
    for( int ii = 0; ii<6; ++ii)
        leds[ii] = !leds[ii];

    //Beendet den Ticker und startet die DistanzLED-Show
    if( ++timer > 10) {
        t1.detach();
        t1.attach( &ledDistance, 0.01f );
    }
}

int main()
{
    pwmL.period(0.00005f); // Setzt die Periode auf 50 μs -> f speichert float anstatt double (schneller)
    pwmR.period(0.00005f);
    pwmL = 0.5f; // Setzt die Duty-Cycle auf 50%
    pwmR = 0.5f;
    enableMotorDriver = 1;

    t1.attach( &ledShow, 0.05f ); //->Was

    //Initialisiert Distanzsensoren
    for( int ii = 0; ii<6; ++ii)
        sensors[ii].init(&distance, &bit0, &bit1, &bit2, ii);

    enable = 1;

    while(1) {
        wait( 0.2f );
        if(sensors[0].read() < 0.2f){
            pwmL = 0.55f;
            pwmR = 0.55f;
        }
        else{
            pwmL = 0.6f;
            pwmR = 0.4f;
        }
//float x = sensor[0];
    }
}
