#include "mbed.h"

//モータードライバー＋回転数計測プログラム

InterruptIn enc(A5);
DigitalOut led(LED1);

int counter =0;

void event_handler(void){
    counter++;
    led =!led;
}


PwmOut AIN1(A1);
PwmOut AIN2(A2);
 
void motorStop(PwmOut IN1,PwmOut IN2) {
    IN1 = 1;
    IN2 = 1;
}
 
void motorForward(PwmOut IN1,PwmOut IN2,float duty) {
    motorStop(IN1,IN2);
    IN1 = duty;
    IN2 = 0;
}
 
void motorReverse(PwmOut IN1,PwmOut IN2,float duty) {
    motorStop(IN1,IN2);
    IN1 = 0;
    IN2 = duty;
}
 

int main() {

    while(1) {
        enc.rise(&event_handler);
        enc.fall(&event_handler);
        
        for(float duty=1.0 ; duty>0 ;duty-=0.1){
        
        motorForward(AIN1,AIN2,duty);
        printf("\nduty:%f\n",duty);
        wait(5);
        counter = 0;
        wait(1);
        printf("%d\n",counter/24);       
        motorStop(AIN1,AIN2);
        wait(1);
        }
        
        for(float duty=1.0 ; duty>0 ;duty-=0.1){
        
        motorReverse(AIN1,AIN2,duty);
        printf("\nduty:%f\n",duty);
        wait(5);
        counter = 0;
        wait(1);
        printf("%d\n",counter/24);//スリットが12個、0から１までで一回１から０までで一回計測するので12の二倍     
        motorStop(AIN1,AIN2);
        wait(1);
        }
 
    }
}