#ifndef __KIDS_WORKSHOP__
#define __KIDS_WORKSHOP__

#include "SB1602E.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

#if defined(TARGET_HRM1017)
SB1602E lcd(P0_22, P0_20, P0_23);
AnalogIn ain(P0_2);
DigitalOut gnd1(P0_10, 0);
DigitalOut gnd2(P0_13, 0);
InterruptIn  din(P0_12);
PwmOut wave(P0_19);
#elif defined(TARGET_LPC1768)
AnalogIn ain(p20);
SB1602E lcd(p9, p10);
DigitalOut gnd1(p5, 0);
DigitalOut gnd1(p6, 0);
InterruptIn  din(p7);
PwmOut wave(p21);
#else
#error This target does not support for this project.
#endif

void init(void);
void key_pressed(void);

int disp_mode;

const int tone_table_us[] = {
3822,
//3608,
3405,
//3214,
3034,
2864,
//2703,
2551,
//2408,
2273,
//2145,
2025,
1911,
0
};

#endif
