#include "mbed.h"
#include "kids_workshop.h"

int main()
{
    init();

    while(1) {
        led1 = 1;  // led1を光らせる
        wait(0.3); // すこしまつ
        led1 = 0;  // led1を消す
        wait(0.3); // すこしまつ
        
        float ondo = ((ain * 3.25 - 0.6) / 0.01);

        if (disp_mode == 0 ) {
            lcd.printf(0, 0, "%2.2f  ", ondo);            
        } else {
            lcd.printf(0, 0, "Hello!");
        }

    }
}

void key_pressed()
{
    static int key = 0;
    
    if (key > 9) {
        key = 0;
    }
    wave.period_us(tone_table_us[key]);
    key++;
    disp_mode = !disp_mode;
}

void init()
{
    disp_mode = 1;
    lcd.setCharsInLine(8);
    lcd.contrast(0x30);
    
    din.mode(PullUp);
    din.fall(&key_pressed);
    
    wave.write(0.5);
    wave.period_us(0);

    // 文字を変えてみよう
    char buf[10];
    buf[0] = 0xb1;
    buf[1] = 0xb0;
    buf[2] = 0xd1;
    buf[3] = 0xc0;
    buf[4] = 0xdb;
    buf[5] = 0xb3;
    buf[6] = 0;
    buf[7] = 0;
    buf[8] = 0;
    lcd.printf(0, 0, "Hello!");
    lcd.printf(0, 1, buf);
}
