#include "mbed.h"
#include "MODSERIAL/MODSERIAL.h"
#include "SerialComm/SerialComm.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define USHRT_MAX 65535
#define POWER_OFF 32768
#define BACKWARD_MAX 0
#define FORWARD_MAX USHRT_MAX
#define SEND_PERIOD_TIME_S 0.002

MODSERIAL pcSerial(USBTX, USBRX);

// Initialize a pins t//o perform analog and digital output fucntions
PwmOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

PwmOut motorPwm(p26);
AnalogOut motorAna(p18);
DigitalOut motorEnable(p12);
Ticker aTimer;
AnalogIn motorSpeed(p15);
AnalogIn potentiometer(p20);
DigitalIn potentiometerEnable(p21);

SerialComm serialComm(&pcSerial);

bool readyToSendNext;
void timerFcn()
{
    readyToSendNext = true;
}

int main(void)
{
    // DEFINE the operation modes
    bool messageMode = true;
    bool analogMode = false;
    led1 = 0.0f;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    motorEnable = 0; // turn off motor
    motorAna.write_u16(POWER_OFF); // set motor pwm to zero
    motorPwm.period_us(800);
    motorPwm = 0.5f;

    uint16_t motorCommandReceived = POWER_OFF;
    uint16_t motorCommandLast = POWER_OFF;
    uint16_t motorSpeedMeas = POWER_OFF;
    float motorCommandFloat = 0.5f;
    pcSerial.baud(115200);
    pcSerial.printf("Start!\n");

    readyToSendNext = false;
    
    //aTimer.attach(&timerFcn, SEND_PERIOD_TIME_S ); // the address of the function to be attached (flip) and the interval (2 seconds)
    
    while(1) {
        if(serialComm.checkIfNewMessage()) {
            // read message from PC in order to clear the buffer
            motorCommandReceived = serialComm.getUnsignedShort();

            // -- ENABLE OR DISABLE MOTOR --
            motorEnable = potentiometerEnable; // set led2 value based on switch of potentiometer
            led2 = motorEnable;

            // -- PC OR POTENTIOMETER Control Mode--
            if(messageMode) { //control through pc
                if(motorCommandLast != motorCommandReceived) {
                    if(analogMode) { //analog
                        motorAna.write_u16(motorCommandReceived);
                    } else { //PWM
                        motorCommandFloat = ((float) motorCommandReceived)/ 65535.0f;
                        motorPwm.write( motorCommandFloat * 0.8f + 0.1f);
                        //led1 = motorCommandFloat; // drive led1 brightness accordingly
                    }
                }
            } else { //potentiometer controlled
                motorCommandReceived = potentiometer.read_u16();
                if(motorCommandLast != motorCommandReceived) {
                    if(analogMode) { //analog
                        motorAna.write_u16(motorCommandReceived);
                    } else { //PWM
                        motorCommandFloat = ((float) motorCommandReceived) / 65535.0f;
                        motorPwm.write( motorCommandFloat * 0.8f + 0.1f);
                        //led1 = motorCommandFloat; // drive led1 brightness accordingly
                    }
                }
            }
            motorCommandLast = motorCommandReceived;
            readyToSendNext = true;
        }

        if(readyToSendNext == true) {
            //led4 = 1;
            // reading in current speed
            motorSpeedMeas = motorSpeed.read_u16();
            //sending speed to host
            //serialComm.sendUnsignedShort(motorSpeedMeas);

            serialComm.sendUnsignedShort(motorCommandReceived);

            readyToSendNext = false;
            //led4 = 0;
        }

    }
}