/*
 * Author: Robert Katzschmann
 */

#include "SerialComm.h"

// Initialization
SerialComm::SerialComm(MODSERIAL* serialObject /* = NULL */):
    messageProcessed(false),
    byte_idx(0)
{
    this->init(serialObject);
}

// Initialization
SerialComm::~SerialComm()
{
}

void SerialComm::init(MODSERIAL* serialObject /* = NULL */)
{
    // Create serial object or use provided one
    if(serialObject == NULL) {
        serialObject = new MODSERIAL(SERIAL_DEFAULT_TX, SERIAL_DEFAULT_RX);
        serialObject->baud(SERIAL_DEFAULT_BAUD);
    }
    serial = serialObject;
    serial->baud(9600);
    serial->attach(this, &SerialComm::rxCallback, MODSERIAL::RxIrq);
}


/*void SerialComm::rxCallback(MODSERIAL_IRQ_INFO *q)
{
    //input = serial->rxGetLastChar();
    //serial->putc(input); // write it back

    MODSERIAL *serial = q->serial;
    
    if (serial->rxBufferGetCount() == FLOATSIZE + 1) {

        if ( serial->rxGetLastChar() == '\n') {
            // *led4 = !(*led4);
            //  // reset byte_idx
            byte_idx = 0;
            //val_idx = 0;
            while(serial->readable()) {

                input = serial->getc(); //temporarily  write to a char
                //serial->putc(input); // write it back

                if (byte_idx < BUFFERSIZE) {
                    // just to avoid buffer overflow
                    // *led3 = !(*led3);
                    //value[val_idx][byte_idx++] = input;  // put it into the value array and increment the byte_idx
                    hi.binary[byte_idx++] = input;
                }
            }

            //value[val_idx][byte_idx-1]='\x0';  // remove newline by writing to byte_idx-1 and add a \x0 to end the c string
            //value[byte_idx]='\x0';  // add an 0 to end the c string, after the newline character
            hi.binary[byte_idx-1] = '\x0';
            messageProcessed = true;
        }
    }

}*/


void SerialComm::rxCallback(MODSERIAL_IRQ_INFO *q)
{
    MODSERIAL *serial = q->serial;
    
    if (serial->rxBufferGetCount() == SHORTSIZE + 1) {

        if ( serial->rxGetLastChar() == '\n') {
            byte_idx = 0;
            while(serial->readable()) {
                input = serial->getc(); //temporarily  write to a char
                if (byte_idx < SHORTSIZE) {
                   received.binary[byte_idx++] = input;
                }
            }
            messageProcessed = true;
        }
    }

}


uint16_t SerialComm::getUnsignedShort()
{
    messageProcessed = false;
    return received.unsigShort;
}


int SerialComm::sendUnsignedShort(uint16_t input)
{
    toBeSent.unsigShort = input;
    for(int i=0; i < SHORTSIZE ; i++) {
        serial->putc(toBeSent.binary[i]);
    }
    serial->putc('\n');
    return 0;
}

bool SerialComm::checkIfNewMessage()
{
    return messageProcessed;

}

/*
float SerialComm::getFloat()
{
    messageProcessed = false;
    //Conversion From Character Array to Float
    //valueFloats[0] =atof(value[0]);
    valueFloats[0] = hi.floatingPoint;
    return valueFloats[0];
}

int SerialComm::sendFloat(float input)
{
    toBeSent.floatingPoint = input;
    for(int i=0; i < FLOATSIZE ; i++) {
        serial->putc(toBeSent.binary[i]);
    }
    serial->putc('\n');
    return 0;
}




void SerialComm::getFloats(float* floats, int howMany)
{
    messageProcessed = false;
    if(howMany<NUMBER_COUNT_MAX)
        for(int i = 0; i < howMany; i++) {
            if(i < howMany) {
                valueFloats[i] = atof(value[i]);
                floats[i] = valueFloats[i];
            } else {
                floats[i] = 0.0;
            }
        }
}
*/

/*
int SerialComm::getInt()
{
    messageProcessed = false;
    // Conversion From Character Array to Integer
    valueInts[0] = atoi(value[0]);

    return valueInts[0];
}
*/

//int SerialComm::getString(char* string)
//{
//    return valueInts;
//}