/*
 * SerialComm.h
 *
 * Author: Robert Katzschmann
 */

#ifndef SERIALCONTROL_SerialComm_H_
#define SERIALCONTROL_SerialComm_H_

#include "mbed.h"
#include "MODSERIAL.h"

#define SERIAL_DEFAULT_BAUD 9600
#define SERIAL_DEFAULT_TX USBTX
#define SERIAL_DEFAULT_RX USBRX
#define BUFFERSIZE 100
#define NUMBER_COUNT_DEF 5
#define NUMBER_COUNT_MAX 20
#define FLOATSIZE 4
#define SHORTSIZE 2

/*
typedef union {
    float floatingPoint;
    uint8_t binary[FLOATSIZE];
} binaryFloat;*/

typedef union {
    uint16_t unsigShort;
    uint8_t binary[FLOATSIZE];
} binaryUShort;


class SerialComm
{
public:
    // Initialization
    SerialComm(MODSERIAL* serialObject = NULL); // if objects are null, ones will be created
    ~SerialComm();

    void init(MODSERIAL* serialObject = NULL); // if serial objects are null, ones will be created
    // Execution control
    
    uint16_t getUnsignedShort();
    int sendUnsignedShort(uint16_t input);

    //float getFloat(); //returns the first float
    //int sendFloat(float input); //returns status
    //void getFloats(float* floats, int howMany = NUMBER_COUNT_DEF);
    
    //int getInt(); //returns the first int
    //void getString();
    bool checkIfNewMessage();

    // char value[NUMBER_COUNT_MAX][BUFFERSIZE];
protected:
    void rxCallback(MODSERIAL_IRQ_INFO *q);

private:

    bool messageProcessed;
    int byte_idx;
    //int val_idx;
    //int valueInts[NUMBER_COUNT_MAX];
    //float valueFloats[NUMBER_COUNT_MAX];
    uint8_t input;
    //char value[NUMBER_COUNT_MAX][BUFFERSIZE];
    MODSERIAL* serial;
    //DigitalOut* led2;
    //DigitalOut* led3;
    //DigitalOut* led4;
    //binaryFloat hi;
    //binaryFloat toBeSent;
    binaryUShort received;
    binaryUShort toBeSent;


};

#endif /* SERIALCONTROL_SerialComm_H_ */