#include "mbed.h"
#include "QEI.h"

/* Code written by Simon Truelove (18/05/2021) Stripped down version of SWM Demonstrator to check operation of TFM encoder RLS LM13ICPRGA00D10A and MR100F085A160M00
using QEI.h. The code uses the pulses from the encoder to calculate RPM
*/

void RPM (void);

Serial pc(USBTX, USBRX);                                // tx, rx - set up the Terraterm input from mbed

QEI wheel(p5, p6, p8, 20000, QEI::X4_ENCODING);           //code for quadrature encoder see QEI.h

Timer t;                                                //timer used in RPM

DigitalOut      led1            (LED1);                 //LEDs used to as very basic memmory for controlling the state machines
DigitalOut      led2            (LED2);
DigitalOut      led3            (LED3);
DigitalOut      led4            (LED4);
DigitalIn       anticlockwise   (p11);
DigitalIn       clockwise       (p15);

DigitalOut      UnUsedPhase1    (p21);
DigitalOut      UnUsedPhase2    (p22);

int TimePerClick = 0;                                   //for calc of RPM
int enc = 80000;                                         //20 000 x4 enc = 80 000 Pulses Per Rev
int s = enc/50;                                         //s=number of cases in state machine (64)
int start = 28;
int adj = 25-start;
     
char c;                                                 //keyboard cotrol GetChar

float rps = 0;                                          //for calc of RPM
float rpm = 0;                                          //for calc of RPM
float TimePerRev = 0;                                   //for calc of RPM

int main(void) 
{   
    pc.baud(460800);                                    //Set baud rate
    wait(2);
    t.start();                                          //start timer for rpm calculation 
    wait(0.1);
        
    while(1)
    { 
        if(wheel.getWhoop()==1)             //PulseCount2_==3200 (this is 1 rotation), whoop_=1;
            {
                RPM();                          //calculate RPM
                led1==1;
                pc.printf("yay= %i, whoop= %i, Pulses= %i, Revs= %i, RPM= %f\n\r", wheel.getYay(),wheel.getWhoop(),wheel.getPulses(),wheel.getRevolutions(), rpm);
            }
        if (pc.readable())   
        {
            c = pc.getc();
            if(c == 'z')                            //turn on led2 print some stuff
            {
                led2 = !led2;
                pc.printf("yay= %i, whoop= %i, Pulses= %i, Revs= %i, RPM= %f\n\r", wheel.getYay(),wheel.getWhoop(),wheel.getPulses(),wheel.getRevolutions(), rpm);           
            }
        }
    }
}
void RPM (void)
{
    wheel.ResetWhoop();                         //Whoop = 1 x per rev
    TimePerClick = (t.read_us());               //read timer in microseconds       
    t.reset();                                  //reset timer
    TimePerRev = TimePerClick;                  //Convert from int to float TimePerClick = int, TimePerRev = float
    TimePerRev = TimePerRev / 1000000;          // 1microsecond = 0.000001s
    rps = 1 / TimePerRev;                       //inverse to convert SPR to rps
    rpm = rps * 60;                             //x 60 to convert rps to RPM
}