#include "mbed.h"
#include "math.h"
#include "Defines.h"
#include "PWM.h"
#include <string> 

//#define PWMPRESCALE (12-1)
#define PWM 200

void InitPWM(int PWMPRESCALE)
{
    LPC_PINCON->PINSEL4  = (1<<0)|(1<<0)|(1<<2)|(1<<4)|(1<<6)|(1<<8)|(1<<10);          //set up the pins to be PWM outputs  '01 01 01 0101 01' is pwm mode put onto Mbed pins 26,25,24,23.          
    LPC_PINCON->PINMODE2 |= (2<<0)|(2<<2)||(2<<4)|(2<<6)|(2<<8)|(2<<10)|(2<<12)|(2<<14)|(2<<16)|(2<<18)|(2<<20)|(2<<22)|(2<<24)|(2<<26)|(2<<28);      // no pull ups                                 //no pull ups/pull downs on PIN1  
    LPC_PWM1->MCR = (1<<0)|(1<<1);                                     //Generate interrupt on mathc, also Reset PWM timer counter on PWM1_MR0 match : match control register 
    
    LPC_PWM1->PR = PWMPRESCALE;                                 //1 micro-second resolution (24 ticks to pclk)
    LPC_PWM1->MR0 = 100;                                         //80 1\2 uS ticks to match = 40uS period  for 25kHz. output goes high every time TCNT matches    
    
    LPC_PWM1->MR1 = 1;                                         //1us - default pulse duration i.e. width. changed by analgo in. output goes low everytime TCN matched 
    LPC_PWM1->MR2 = 1;                                         //match comapre registers for the 4 PWM channels 
    LPC_PWM1->MR3 = 1;                      
    LPC_PWM1->MR4 = 1;
    LPC_PWM1->MR5 = 1;
    LPC_PWM1->MR6 = 1;
    
    LPC_PWM1->LER = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6);         //update values in MR0 and MR1: latch enabe register 
    LPC_PWM1->TCR = (1<<1);                                     //Reset PWM timer counter & prescale counter : timer control register 
    LPC_PWM1->TCR = (1<<0) | (1<<3);                            //Enable counters and enter PWM Mode, **PWM Generation goes active now**   
    NVIC_EnableIRQ(PWM1_IRQn); 
 
}






void EnablePWM(unsigned char PWMChannel)
{
    switch(PWMChannel)
    {
        case 1: LPC_PWM1->PCR |= (1<<9);  break;        //pin 20
        case 2: LPC_PWM1->PCR |= (1<<10); break;
        case 3: LPC_PWM1->PCR |= (1<<11); break;
        
        case 4: LPC_PWM1->PCR |= (1<<12); break; 
        case 5: LPC_PWM1->PCR |= (1<<13); break; 
        case 6: LPC_PWM1->PCR |= (1<<14); break;        //pin 26 
    }
}



void DisablePWM(unsigned char PWMChannel)
{ 
    switch(PWMChannel)
    {
        case 1: 
        LPC_PWM1->MR1 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<1);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);                                                 //wait for LER to take affect 
        LPC_PWM1->PCR &= 0xfdff; break;                               //disable the PWM channel - it stops low, PCR is pulse width control register- enables PWM channels 
        
        case 2: 
        LPC_PWM1->MR2 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<2);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);
        LPC_PWM1->PCR &= 0xfbff; break;                               //bits 9,10,11 and 12 enable PWM 1,2,3,4. 
        
        case 3: 
        LPC_PWM1->MR3 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<3);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);
        LPC_PWM1->PCR &= 0xf7ff; break;        //clear all of these bits 
        
        case 4: 
        LPC_PWM1->MR4 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<4);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);
        LPC_PWM1->PCR &= 0xefff; break;
        
        case 5: 
        LPC_PWM1->MR5 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<5);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);
        LPC_PWM1->PCR &= 0xDfff; break;
        
        case 6: 
        LPC_PWM1->MR6 = 0;                                          //set duty to zero - ensures safe turn off
        LPC_PWM1->LER = (1<<6);                              //update values in MR0 and MR1: latch enabe register 
        wait(0.002);
        LPC_PWM1->PCR &= 0xBfff; break;
    }
}



void SetPWM(int a,int b,int c,int d,int e,int f)
{  
    LPC_PWM1->MR1 = a;                                         //1us - default pulse duration i.e. width. changed by analgo in 
    LPC_PWM1->MR2 = b;                                         //match comapre registers for the 4 PWM channels 
    LPC_PWM1->MR3 = c;                      
    LPC_PWM1->MR4 = d;
    LPC_PWM1->MR5 = e;
    LPC_PWM1->MR6 = f;
    LPC_PWM1->LER = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6);         //update values in MR0 and MR1: latch enabe register 
}







