#include "mbed.h"
#include "math.h"
#include "Defines.h"
#include "PWM.h"
#include "ADC.h"
#include <string> 

void ADC_Init(void)
{
    LPC_SC->PCONP           |= (1<<12);                             //Enable ADC power, do first
    LPC_ADC->ADCR           |= (1<<21)|(3<<8)|(1<<0);                             //ADC is turned on , 
                                      
    
    LPC_PINCON->PINSEL1     |= (1<<14)|(1<<16)|(1<<18)|(1<<20);     //select AD0.0/1/2/3 : need 01 in pin select sel 1    
    LPC_PINCON->PINMODE1    |= (2<<14)|(2<<16)|(2<<18)|(2<<20);     //no pullup for the ADC lines 
    
    LPC_PINCON->PINSEL3     = 0xF0000000;//(3<<28)|(3<<30);     //select AD0.0/1/2/3 : need 01 in pin select sel 1
    LPC_PINCON->PINMODE3    = 0xA0000000;//  (2<<28)|(2<<30);     //no pullup for the ADC lines 
    
    LPC_ADC->ADINTEN        |= (1<<0);
    
    NVIC_EnableIRQ(ADC_IRQn);      
}



void ADC_Convert(void)
{
    LPC_ADC->ADCR |=  (1<<24);                   //Start new Conversion
}





  

