#include "ADXL345HL.h"

void ADXL345HL::init(int calibsamples, int readsampls, float samplrate)
{
    accelerometer=new ADXL345_I2C(p28,p27);
    calibrationsamples=calibsamples;
    readsamples=readsampls;
    samplerate=samplrate;
    output=new double[3];
    //Go into standby mode to configure the device.
    accelerometer->setPowerControl(0x00);
    wait(0.001);
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer->setDataFormatControl(0x0B);
    wait(0.001);
    //200Hz data rate.
    accelerometer->setDataRate(ADXL345_200HZ);
    wait(0.001);
    //Measurement mode.
    accelerometer->setPowerControl(0x08);
    //See http://www.analog.com/static/imported-files/application_notes/AN-1077.pdf
    wait_ms(22);
}

void ADXL345HL::calibrateAccelerometer(void)
{

    double a_xAccumulator = 0;
    double a_yAccumulator = 0;
    double a_zAccumulator = 0;

    //Take a number of readings and average them
    //to calculate the zero g offset.
    for (int i = 0; i < calibrationsamples; i++) {

        accelerometer->getOutput(readings);

        a_xAccumulator += (int16_t) readings[0];
        a_yAccumulator += (int16_t) readings[1];
        a_zAccumulator += (int16_t) readings[2];

        wait(samplerate);

    }

    a_xAccumulator /= calibrationsamples;
    a_yAccumulator /= calibrationsamples;
    a_zAccumulator /= calibrationsamples;

    //At 4mg/LSB, 250 LSBs is 1g.
    xBias = a_xAccumulator;
    yBias = a_yAccumulator;
    zBias=a_zAccumulator;
    //zBias = (a_zAccumulator - 250);

    a_xAccumulator = 0;
    a_yAccumulator = 0;
    a_zAccumulator = 0;
}


double* ADXL345HL::sampleAccelerometer(void)
{
    double a_xAccumulator = 0;
    double a_yAccumulator = 0;
    double a_zAccumulator = 0;
    for (int i=0; i<readsamples; ++i) {
        accelerometer->getOutput(readings);
        a_xAccumulator += (int16_t) readings[0];
        a_yAccumulator += (int16_t) readings[1];
        a_zAccumulator += (int16_t) readings[2];
    }
    //Average the samples, remove the bias, and calculate the acceleration
    //in m/s/s.
    output[0] = ((a_xAccumulator / readsamples) - xBias) * ACCELEROMETER_GAIN;
    output[1] = ((a_yAccumulator / readsamples) - yBias) * ACCELEROMETER_GAIN;
    output[2] = ((a_zAccumulator / readsamples) - zBias) * ACCELEROMETER_GAIN;
    return output;
}


ADXL345HL::ADXL345HL()
{
}

ADXL345HL::~ADXL345HL()
{
    delete[] output;
    delete accelerometer;
}