#include "ADXL345_I2C.h"
#include "ADXL345HL.h"
#include "ITG3200HL.h"

#include "IMUfilter.h"


//ADXL345_I2C accelerometer(p28, p27);
ADXL345HL accel;
ITG3200HL gyro;
//ITG3200 gyro(p28, p27);
Serial pc(USBTX, USBRX);
IMUfilter imuFilter(0.1, 10);

int main()
{
    accel.init(20,4,0.004);
    accel.calibrateAccelerometer();
    gyro.init(20,4,0.004);
    gyro.calibrate();
    while (1) {

        wait(0.1);
        double* accelreadings=accel.sampleAccelerometer();
        double* gyroreadings=gyro.sample();
        imuFilter.updateFilter(gyroreadings[0],gyroreadings[1],gyroreadings[2],accelreadings[0],accelreadings[1],accelreadings[2]);
        imuFilter.computeEuler();
        pc.printf("roll: %f, pitch: %f, yaw: %f\n", imuFilter.getRoll(), imuFilter.getPitch(), imuFilter.getYaw());
        //pc.printf("aceelerometer: %f, %f, %f\n", readings[0], readings[1], readings[2]);
        //pc.printf("gyro: %i, %i, %i\n", gyros[0],gyros[1],gyros[2]);
    }

}