#pragma once
#include "ADXL345_I2C.h"


//Gravity at Earth's surface in m/s/s
#define g0 9.812865328
//Number of samples to average.
#define SAMPLES 4
//Convert from radians to degrees.
#define toDegrees(x) (x * 57.2957795)
//Convert from degrees to radians.
#define toRadians(x) (x * 0.01745329252)
//Full scale resolution on the ADXL345 is 4mg/LSB.
#define ACCELEROMETER_GAIN (0.004 * g0)
//Sampling accelerometer at 200Hz.
#define ACC_RATE    0.005

class ADXL345HL
{
private:
    ADXL345_I2C* accelerometer;
    int readings[3];
    double xBias;
    double yBias;
    double zBias;
    double* output; //x,y,z
    char address;   //i^2c device address
    int calibrationsamples;
    int readsamples;
    float samplerate;
public:
    void init(int calibsamples, int readsampls, float samplrate);
    void calibrateAccelerometer(void);
    double* sampleAccelerometer(void);
    ADXL345HL();
    ~ADXL345HL();
};