#include "motor_controller.h"

PololuMController::PololuMController(PinName pwmport, PinName A, PinName B)
    :pwm(pwmport),outA(A),outB(B)
{
    outA.write(0);
    outB.write(1);
}

void PololuMController::setpolarspeed(float speed)
{
    if (speed>=0) {
        outA.write(0);
        outB.write(1);
        pwm.write(abs(speed));
    } else {
        outA.write(1);
        outB.write(0);
        pwm.write(abs(speed));
    }
    return;
}
