#include "PwmIn.h"
 
PwmIn::PwmIn(PinName p, float dutyMin, float dutyMax) 
    : _p(p) {
    _p.rise(this, &PwmIn::rise);
    _p.fall(this, &PwmIn::fall);
    _period = 20000;
    _pulsewidth = 0;
    _t.start();
    _risen = false;
    _dutyMin = dutyMin;
    _dutyMax = dutyMax;
    _dutyDelta = dutyMax - dutyMin;

}
 
float PwmIn::period() {
    return float(_period)/1000000;
}
 
float PwmIn::pulsewidth() {
    return float(_pulsewidth)/1000000;
}
 
float PwmIn::dutycycle() {
    return float(_pulsewidth) / float(_period);
}

float PwmIn::dutycyclescaledup() {
    float duty = float(_pulsewidth) / float(_period);
    float dutyAdjusted = (duty > _dutyMin) ? ((duty-_dutyMin)/_dutyDelta) : 0.0;
    return (dutyAdjusted < 1.0) ? dutyAdjusted : 1.0;
     
}
 
void PwmIn::rise()
{
    _tmp = _t.read_us();
    if(_tmp > 19000) {
        _period = _tmp;
        _risen = true;
        _t.reset();
    }
}

void PwmIn::fall()
{
    _tmp = _t.read_us();
    if(_tmp > 500 && _tmp < 5000 && _risen == true) {
        _pulsewidth = _tmp;
        _risen = false;
    }
}

    