#ifndef MBED_MAINCONTROLLER_H
#define MBED_MAINCONTROLLER_H

#include "mbed.h"
#include "rtos.h"
#include "PwmIn.h"
#include "motor_controller.h"
//#include "guardian.h"
//#include "IMU.h"
#include "Servo.h"
#include "pixy.h"
#include "servoloop.h"



#define MATH_PI 3.14159265359
#define START_THREAD 1

/** MainController class to get control inputs and place them onto the system
 *
 *
 */
class MainController
{
public:
    /** Create a MainController
     *
     * @param
     */
    MainController() ;
    ~MainController();

    /** Start the main controller
     *
     * @returns
     */
    void start();

    float getDutyCycle();
    float getFrequency();
    float getVolume();
    float getAmplitude();
    float getYaw();
    float getPitch();
    float getAdj();
    bool getOpMode(); //returns true when in autonomous mode

    /** Stop the main controller
     *
     * @returns
     */
    void stop();


protected:
    void control();
    void trackTarget();
    float calculateFrequency();
    float calculateAmplitude();
    float calculateYaw();
    float calculatePitch();
    float calculateAdj();
    float signum(float input);
    float saturate(float input);

private:
    PwmIn ch1;
    PwmIn ch2;
    PwmIn ch3;
    PwmIn ch4;
    PwmIn ch6;
    PwmIn ch5;
    Serial syren; //syren replaced the pololu controller
    //Guardian ap;
    Servo leftservo;
    Servo rightservo;
    ServoLoop panLoop;
    ServoLoop tiltLoop;

    pixySPI pcam;

    Timer timer1;
    Ticker ticker1;
    //RtosTimer controlTimer;
    Ticker tracker;
    Mutex trackMutex;
    //Thread dutyThread;
    //static void dutyThreadStarter(void const* p);
    Thread controlThread;
    static void controlThreadStarter(void const* p);
    void updateDutyCycle();
    Thread trackerThread;
    static void trackerThreadStarter(void const *p);
    float amp;
    float ampCmd;
    float frq;
    float dutyCycle;
    float curTime;
    float frqMin;
    float frqMax;
    float yaw;
    float pitch;
    float adj;
    float yawAdjVal;
    bool fullCycle;
    float volume;
    float volMax;
    float frqCmd;
    float raiser;
    float pitAvg;
    float alPi;
};


#endif


