/*********************************************************************************
* This code simply creates a pwm value for the BCU motor, valve motor, and pump
* motor. The BCU motor direction is governed by BCU_direction1 and
* BCU_direction2. If connected to a PC terminal, it prints out current readings.
*********************************************************************************/

#include "mbed.h"
using namespace std;

Serial pc(USBTX, USBRX);
AnalogIn valve_current(p19);
AnalogIn bcu_current(p20);
PwmOut valve_pwm(p21);
PwmOut bcu_pwm(p22);
PwmOut motor_pwm(p23);
DigitalOut led2(LED2);
DigitalOut bcu_direction1(p11);
DigitalOut bcu_direction2(p12);

int main() {
    // set serial transfer rate
    pc.baud(9600);
    
    valve_pwm = 0.8;
    bcu_pwm = 0.8;
    motor_pwm = 0.8;
    
    led2 = 1;
    bcu_direction1 = 0; // BCU_direction1 must not equal BCU_direction2 for the BCU motor to turn
    bcu_direction2 = 1;

    while(1) {
        pc.printf("valve current percentage: %3.3f%%\n", valve_current.read()*100.0f);
    }
}