/*********************************************************************************
* This code sets the valve motor to a pwm of 0.8. It also sets interrupts for the
* hall sensor input, so on each rising and falling edge, LED1 is flipped, testing
* the ability of the mbed to accurately detect the hall sensor reading. Lastly,
* this code configures the BNO055 and prints the yaw, pitch, and roll to a PC
* terminal.
*********************************************************************************/

#include "mbed.h"
#include "BNO055.h"
using namespace std;

Serial pc(USBTX, USBRX);

// BNO055
BNO055 bno055(p28, p27);

// Hall Sensor
InterruptIn hallVoltage1(p8);
DigitalOut led1(LED1);

// Motor Driver
PwmOut valve_pwm(p21);

void flipLed1() {
    led1 = !led1;
}

int main() {
    led1 = 0;
    hallVoltage1.rise(&flipLed1);
    hallVoltage1.fall(&flipLed1);
    
    valve_pwm = 0.8;
    
    bno055.reset();
    bno055.setmode(OPERATION_MODE_NDOF);
    bno055.write_calibration_data();
    bno055.get_calib();
    while (bno055.calib == 0) {
        bno055.get_calib();
    }
    
    while(1) {
        bno055.get_angles(); //query the i2c device
        pc.printf("yaw:%6.2f pitch:%6.2f roll:%6.2f\n",bno055.euler.yaw, bno055.euler.pitch, bno055.euler.roll);
    }
}