#pragma once
#include "mbed.h"

#define INVALID_BLOCK 20
#define CENTER_X 160
#define CENTER_Y 100
#define NUM_BLOCKS 10
//a class to aid in SPI communication with the pixy camera

//this details the object block format of returned data as described in
//http://www.cmucam.org/projects/cmucam5/wiki/Pixy_Serial_Protocol

//blatantly stole this from their code
struct Block 
{
  uint16_t signature;
  uint16_t x;
  uint16_t y;
  uint16_t width;
  uint16_t height;
};

class pixySPI
{
private:
    SPI spi;
    //SPI spi(p5, p6, p7); // mosi, miso, sclk
    short sync; //the block signature. 16 bits
    short readTwoBytesLSB();
    void readNBytes(char* buf, int num);
    Block blocks[NUM_BLOCKS]; //where the blocks are stored
    int numBlocks; //amt
    int bestX;
    int bestY;
public:
    pixySPI(PinName mosi,PinName miso,PinName sclk, int nBlocks);
    ~pixySPI();
    void capture(); //fills in the blocks pointer
    char getRawData();
    Block* getBlocks();
    int getNumBlocks();
    int getBestX();
    int getBestY();
};