#include "pixy.h"

pixySPI::pixySPI(PinName mosi, PinName miso, PinName sclk, int nBlocks)
    :spi(mosi,miso,sclk)
{
    spi.format(8,0); //8bits mode 0
    spi.frequency(100000); //set the frequency in Hz
    sync=0xAA55; //start word of a frame coming from the pixy
    //blocks=new Block[nBlocks]; //allocate space for the blocks
    //numBlocks=nBlocks;
    numBlocks=NUM_BLOCKS;
    bestX=CENTER_X;
    bestY=CENTER_Y;
}

pixySPI::~pixySPI()
{
    delete blocks;
}


short pixySPI::readTwoBytesLSB()
{
    short out;
    char read[2]= {0,0};
    read[0]=spi.write(0x00);
    read[1]=spi.write(0x00);
    out=(((short)read[0]) << 8) | read[1];
    return out;
}


//this doesn't work
void pixySPI::readNBytes(char* buf, int num)
{
    for (int i=0; i<num; i++) {
        char byte=spi.write(0x00);
        memcpy(buf+i, &byte, 1);
    }
}

void pixySPI::capture()
{
    memset(blocks, 0, numBlocks*sizeof(Block)); //destroy the old targets
    for (int i=0; i<numBlocks; ++i) {
        // printf("block %d\n", i);
        Block* out=&blocks[i];
        out->signature=INVALID_BLOCK;
        uint16_t checksum=0;
        //first we need to detect the start of a block. They all start with 0xAA55
        char frame[2]= {0,0}; //this is a 2 byte running frame of what is being recieved. It's like a first-in-last-out queue
        //debug->printf("looking for valid signature\n");
        Timer t;
        t.start();
        while (memcmp((char*)&sync, frame, 2)!=0) {
            frame[0]=frame[1]; //move byte down
            frame[1]=spi.write(0x00); //get next byte.
            if (t.read_ms()>5)
            {
                t.stop();
                return;
            }
        }
        //printf("target\n\n");
        spi.write(0x00);
        //ok so we got a valid signature
        //these didn't end up working
        //readNBytes((char*)(&checksum), 2); //get the checksum
        //readNBytes((char*)(&out), sizeof(Block)); //get the rest of the data
        checksum=readTwoBytesLSB();
        out->signature=readTwoBytesLSB();
        out->x=readTwoBytesLSB();
        out->y=readTwoBytesLSB();
        out->width=readTwoBytesLSB();
        out->height=readTwoBytesLSB();

        if (checksum!=(out->x+out->y+out->signature+out->width+out->height) || checksum==0) {
            //debug->printf("checksum doesn't add up %d\n", checksum);
            out->signature=INVALID_BLOCK; //used for invalid signatures
        }
        //printf("found block\n");
        if (blocks[0].signature!=INVALID_BLOCK)
        {
            //mutex->lock();
            bestX=blocks[0].x;
            bestY=blocks[0].y;
            //mutex->unlock();
        }
    }
    return;
}

Block* pixySPI::getBlocks()
{
    return blocks;
}

int pixySPI::getNumBlocks()
{
    return numBlocks;
}

int pixySPI::getBestX()
{
    if (bestX>640)
        return 640;
    else if (bestX<0)
        return 0;
    else
        return bestX;
}

int pixySPI::getBestY()
{
    if (bestY>400)
        return 400;
    else if (bestY<0)
        return 0;
    else
        return bestY;
}

char pixySPI::getRawData()
{
    return spi.write(0x00);
}