#pragma once
#include "mbed.h"
#include "Servo.h"
#include "MS5803.h"

class IMUDepthControl
{
private:
    MS5803 IMU;
    float m_set_point;
    float m_Kp;
    float m_Ki;
    float m_errorsum;
    float m_delta_t;
    float m_last_pos;
    Timer t;
    Servo output;
    
    Ticker feedback;
public:
    IMUDepthControl(PinName sda, PinName scl, float Kp, float Ki);
    void setPoint(float setpoint);
    void iterate();
};