#pragma once
#include "mbed.h"

class PwmReader
{
    public:
    PwmReader();
    PwmReader(PinName pwmInPort, float min = 0.0, float max = 1.0);
    ~PwmReader();
    
    float getDuty();         //0 to 1
    
    protected:
    void pwmRise();    
    void pwmFall();    
    void pwmRise2();    
    void pwmFall2(); 
    
    private:
    InterruptIn* di;
    int lastRise;
    int period;
    float duty;
    Timer t;
    float pwmMin;
    float pwmMax; 
    
};