#include "PwmReader.h"

//Constructors
PwmReader::PwmReader(PinName pwmInPort, float min, float max)
{
    if (min > max)
    {
        error("PwmReader min value greater than max value!");
    }
    
    di = new InterruptIn(pwmInPort);
    pwmMin = min;
    pwmMax = max;
    lastRise = 0;
    period = 0;
    duty = 0.0;
    di->mode(PullDown);
    di->rise(this,&PwmReader::pwmRise);  // attach the address of the flip function to the rising edge
    di->fall(this,&PwmReader::pwmFall);
    
    t.start();
}

PwmReader::~PwmReader()
{
    delete di;
    t.stop();
}

// public methods
float PwmReader::getDuty()
{
    float smallDelta = (duty > pwmMin) ? (duty - pwmMin) : 0.0;
    float dutyAdjusted = smallDelta / (pwmMax-pwmMin);
    return dutyAdjusted;
}

// private methods
void PwmReader::pwmRise()
{
    int rise = t.read_us();
    if( (lastRise > 0) && (rise > lastRise) ) {
        period = rise - lastRise;
    }
    lastRise = rise;

}

void PwmReader::pwmFall()
{
    int fall = t.read_us();
    if(period > 0 ) {
        int delta = fall - lastRise;
        duty = float(delta)/float(period); 
    }
}