
#ifndef MBED_PWMIN_H
#define MBED_PWMIN_H
 
#include "mbed.h"
 
/** PwmIn class to read PWM inputs
 * 
 * Uses InterruptIn to measure the changes on the input
 * and record the time they occur
 *
 * @note uses InterruptIn, so not available on p19/p20
 */
class PwmIn {
public:
    /** Create a PwmIn
     *
     * @param p The pwm input pin (must support InterruptIn)
     */ 
    PwmIn(PinName p, float dutyMin, float dutyMax) ;
    
    /** Read the current period
     *
     * @returns the period in seconds
     */
    float period();
    
    /** Read the current pulsewidth
     *
     * @returns the pulsewidth in seconds
     */
    float pulsewidth();
    
    /** Read the current dutycycle
     *
     * @returns the dutycycle as a percentage, represented between 0.0-1.0
     */
    float dutycycle();
    
    float dutycyclescaledup();
 
protected:        
    void rise();
    void fall();
    
    InterruptIn _p;
    Timer _t;
    int _pulsewidth, _period;
    int _tmp;
    float _dutyMin, _dutyMax, _dutyDelta;
    
    bool _risen;
};
 
#endif