#ifndef MBED_MAINCONTROLLER_H
#define MBED_MAINCONTROLLER_H
 
#include "mbed.h"
#include "PwmIn.h"
#include "motor_controller.h"
#include "guardian.h"
//#include "IMU.h"


#define MATH_PI 3.14159265359
 
/** MainController class to get control inputs and place them onto the system
 * 
 * 
 */
class MainController {
public:
    /** Create a MainController
     *
     * @param 
     */ 
    MainController() ;
    
    /** Start the main controller
     *
     * @returns 
     */
    void start();
    
    float getDutyCycle();
    float getFrequency();
    float getVolume();
    float getAmplitude();
    float getRudder();
    
    /** Stop the main controller
     *
     * @returns 
     */
    void stop();
    
 
protected:        
    void control();
    float calculateFrequency();
    float calculateVolume();
    float calculateRudder();
    float signum(float input);
    float saturate(float input);
    
private:
    PwmIn ch3;
    PwmIn ch4;
    PwmIn ch6;
    PololuMController mcon;
    Guardian ap;
    
    
    Timer timer1;
    Ticker ticker1;
    float vol;
    float frq;
    float dutyCycle;
    float curTime;
    float frqMin;
    float frqMax;
    float amplitude;
    float rud;
    float goofftime;
    bool switched;
};
 
#endif


