#include "guardian.h"

Guardian::Guardian(PinName modpin, PinName gainpin)
:mod(modpin),
gain(gainpin)
{

    mod.write(0.5); //set autopilot to off
    gain.write(1.00);
}

void Guardian::set3D() //set autopilot to 3D
{
    mod.write(1.00);
    return;
}

void Guardian::set2D() //set autopilot 2D
{
    mod.write(0.00);
    return;
}

void Guardian::setoff()
{
    mod.write(0.5);
    return;
}

void Guardian::calibrate() //must be done within 15 sec of power on
{
    set2D();
    wait(500);
    set3D();
    wait(500);
    set2D();
    wait(2000);
    //now look for the twitch
    return;
}

void Guardian::setmod(float val)
{
    mod.write(val);
    return;
}

void Guardian::setgain(float val)
{
    gain.write(val);
    return;
}